/*
  Teste les fonctions de primes16

  Les valeurs de 1  761 856 001 ont dj t testes par mes soins

  (c) Olivier Pirson --- http://www.opimedia.be/ --- olivier.pirson.opi@gmail.com
  4 octobre 2011
*/

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

#include "primes16.h"



/*************
 * Fonctions *
 *************/
void test_nat32_to_nat32_array_primefactors_(nat32 n) {
  nat32 prod;

  nat32 factors[NAT32_MAX_NB_FACTORS + 1];

  unsigned int mu;

  bool ok = true;


  puts("- nat32_to_nat32_array_primefactors()...");
  fflush(stdout);

  for ( ; n != 0; n++) {
    if ( (n&65535) == 1 ) {
      printf("%" NAT32_FORMAT " ", n);
      fflush(stdout);
    }


    mu = nat32_to_nat32_array_primefactors(n, factors);
 
    prod = nat32_array_to_nat32_product(factors, mu);
    if ( prod != n ) ok = false;

    if ( factors[mu] != 0 ) ok = false;


    if ( !ok ) {
      printf("\n* %" NAT32_FORMAT " (%u) ", n, mu);
      print_nat32_array(factors, mu, "", ", ");
      puts("* !!!");
      fflush(stdout);
    }
  }
  puts("");
}


void test_primes16_init() {
  puts("- primes16_init()...");
  fflush(stdout);
  primes16_init();
}


void test_ui_in_primes16(){
  const unsigned int not_primes[] = {0, 1, 4, 6, 8, 9, 10, 12,
                                     2};

  const unsigned int *p;

  unsigned int i;


  puts("- ui_in_primes16()...");
  fflush(stdout);

  for (p = not_primes ; *p != 2; p++) {
    if ( ui_in_primes16(*p) ) {
      printf("* %u * !!!\n", *p);
      fflush(stdout);
    }
  }

  for (i = 1; i < 17; i++) {
    unsigned int n = PRIMES16_MAX + i;

    if ( ui_in_primes16(n) ) {
      printf("* %u * !!!\n", n);
      fflush(stdout);
    }
  }

  for (p = primes16 ; *p; p++) {
    if ( (*p != 3) && ui_in_primes16(*p - 1) ) {
      printf("* %u * !!!\n", *p);
      fflush(stdout);
    }
    if ( !ui_in_primes16(*p) ) {
      printf("* %u * !!!\n", *p);
      fflush(stdout);
    }
    if ( (*p != 2) && ui_in_primes16(*p + 1) ) {
      printf("* %u * !!!\n", *p);
      fflush(stdout);
    }
  }
}


/********
 * Main *
 ********/
int main(int argc, char *argv[]) {
  nat32 n_init = 1;

  if ( argc > 1 ) {
    n_init = strtoul(argv[1], NULL, 10);
    if ( n_init < 1 ) {
      n_init = 1;
    }
  }

  test_primes16_init();

  test_ui_in_primes16();

  test_nat32_to_nat32_array_primefactors_(n_init);

  puts("- END");
  fflush(stdout);

  return EXIT_SUCCESS;
}
