/*
  Version clarifie de gr32.c

  Si un paramtre est spcifi sur la ligne de commande
  alors calcule  partir de cette valeur plutt qu'une valeur alatoire comme dans gr32.c


  (c) Olivier Pirson --- http://www.opimedia.be/ --- olivier.pirson.opi@gmail.com
  Dbut le 28 septembre 2011
  9 octobre 2011
*/

#include <stdlib.h>
#include <time.h>



int main(int argc, char *argv[]) {
  /*
    i : 0, 1, 2, 3, 4, ... , x
    odd : 3, 5, 7, ... , x-1 ou x
    sigmaodd : somme des diviseurs impairs de x
    x : succession des GR(...), qui aboutit normalement  96
  */
  unsigned long i, odd, sigmaodd, x;

  srand(time(NULL));
  x |= rand();


  if ( argc > 1 ) {
    x = strtoul(argv[1], NULL, 10);
  }


  for (i = 0; i <= x; i++) {
    sigmaodd = 1;
    for (odd = 3; odd <= x; odd += 2) {
      if ( x%odd == 0 ) {
        sigmaodd += odd;
      }
    }

    x = sigmaodd*(x&1
                  ? 8
                  : 24);
  }

  return x;
}
