/*
  Version de gr32.c pour vrifier les valeur tenant sur un unsigned long (32 bits)
  avec mmoization et un calcul de la somme des diviseurs impairs optimis par factorisation du nombre

  Si un paramtre est spcifi sur la ligne de commande
  alors commence  cette valeur plutt qu' 0


  (c) Olivier Pirson --- http://www.opimedia.be/ --- olivier.pirson.opi@gmail.com
  Dbut le 4 octobre 2011
  9 octobre 2011
*/

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "primes16/primes16.h"



#define GR_TABLE_MAX 0x3ffffff  /* 2^26 - 1 */


int main(int argc, char *argv[]) {
  unsigned long *gr_table;  /* y mmorise les valeurs de la fonction GR pour les x <= GR_TABLE_MAX */

  /*
    x_init : essayer valeur sur deux tenant sur un unsigned long
    x : succession des GR(...), qui aboutit ( quelques exception prs)  96
  */
  unsigned long x_init = 0;

  if ( sizeof(x_init) != 4 ) {
    puts("unsigned long must be 32 bits!");

    return EXIT_FAILURE;
  }


  gr_table = calloc(GR_TABLE_MAX + 1, sizeof(unsigned long));
  gr_table[0] = 24;

  primes16_init();


  if ( argc > 1 ) {
    x_init = strtoul(argv[1], NULL, 10);
  }


  do {
    unsigned long i = 0,
      x = x_init;

    if ( (x_init&0x7fff) == 1 ) {  /* pour suivre (sur la sortie standard et la sortie des erreurs) la progression des vrifications */
      if ( (x_init&0x3ffff) == 1 ) {
        fprintf(stderr, "%lu ", x_init);
        fflush(stderr);
      }
      printf("%lu ", x_init);
      fflush(stdout);
    }

    /* i : 0, 1, 2, 3, 4, ... , x */
    for ( ; (x != 96) && (i <= x); i++) {
      if ( x == 4294967295ul ) {
        fprintf(stderr, "\n** %lu: %lu infinite loop **\n", x_init, x);
        fflush(stderr);
        printf("\n** %lu: %lu infinite loop **\n", x_init, x);
        fflush(stdout);

        break;
      }

      /*
        x = GR(x)
      */
      if ( x <= GR_TABLE_MAX ) {  /* x assez petit pour que GR(x) soit dans table_gr */
        if ( !gr_table[x] ) {  /* GR(x) pas encore calcul */
          gr_table[x] = nat32_to_nat32_sigma_odd(x)*(x&1
                                                     ? 8
                                                     : 24);
        }
        x = gr_table[x];
      }
      else {                      /* x trop grand pour que GR(x) soit dans table_gr */
        x = nat32_to_nat32_sigma_odd(x)*(x&1
                                         ? 8
                                         : 24);
      }
    }

    if ( x != 96 ) {  /* si rsultat diffrent du 96 attendu ! */
      fprintf(stderr, "\n** %lu: %lu **\n", x_init, x);
      fflush(stderr);
      printf("\n** %lu: %lu **\n", x_init, x);
      fflush(stdout);
    }
  } while ( ++x_init );

  puts("- END");
  fflush(stdout);

  return EXIT_SUCCESS;
}
