/*
  Version de gr32.c pour vrifier les valeurs tenant sur un unsigned long (32 bits)

  Si un paramtre est spcifi sur la ligne de commande
  alors commence  cette valeur plutt qu' 0


  (c) Olivier Pirson --- http://www.opimedia.be/ --- olivier.pirson.opi@gmail.com
  Dbut le 29 septembre 2011
  9 octobre 2011
*/

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
  /*
    x_init : essayer valeur sur deux tenant sur un unsigned long
    x : succession des GR(...), qui aboutit ( quelques exception prs)  96
  */
  unsigned long x_init = 0;

  if ( sizeof(x_init) != 4 ) {
    puts("unsigned long must be 32 bits!");

    return EXIT_FAILURE;
  }


  if ( argc > 1 ) {
    x_init = strtoul(argv[1], NULL, 10);
  }


  do {
    unsigned long i = 0,
      x = x_init;

    if ( (x_init&0x3ff) == 1 ) {  /* pour suivre (sur la sortie standard et la sortie des erreurs) la progression des vrifications */
      if ( (x_init&0x3fff) == 1 ) {
        fprintf(stderr, "%lu ", x_init);
        fflush(stderr);
      }
      printf("%lu ", x_init);
      fflush(stdout);
    }

    /* i : 0, 1, 2, 3, 4, ... , x */
    for ( ; (x != 96) && (i <= x); i++) {
      unsigned long x_odd = x;

      if ( x == 4294967295ul ) {
        fprintf(stderr, "\n** %lu: %lu infinite loop **\n", x_init, x);
        fflush(stderr);
        printf("\n** %lu: %lu infinite loop **\n", x_init, x);
        fflush(stdout);

        break;
      }

      while ( x && !(x_odd&1) ) {  /* tant que x_odd est pair non nul, on le divise par 2 */
        x_odd /= 2;
      }

      {
        /*
          odd : 3, 5, 7, ... , x-1 ou x
          sigmaodd : somme des diviseurs impairs de x_odd (== somme des diviseurs impairs de x)
        */
        unsigned long odd = 3,
          sigmaodd =  1;

        for ( ; odd <= x_odd; odd += 2) {
          if ( x_odd%odd == 0 ) {
            sigmaodd += odd;
          }
        }

        /*
          x = GR(x) si x >= 1,
              24    si x == 0
        */
        x = sigmaodd*(x&1
                      ? 8
                      : 24);
      }
    }

    if ( x != 96 ) {  /* si rsultat diffrent du 96 attendu ! */
      fprintf(stderr, "\n** %lu: %lu **\n", x_init, x);
      fflush(stderr);
      printf("\n** %lu: %lu **\n", x_init, x);
      fflush(stdout);
    }
  } while ( ++x_init );

  puts("- END");
  fflush(stdout);

  return EXIT_SUCCESS;
}
