#!/usr/bin/env python
# -*- coding: latin-1 -*-

import re
import sys


import DSPython.factors  # package available on http://www.opimedia.be/DS/DSPython/



def n_to_str(n):
    if n == 0:
        return '0'

    s = []

    while n:
        n, f = divmod(n, 1000)
        s.append(('000' + str(f))[-3:])

    s = '&thinsp;'.join(reversed(s))

    while s[0] == '0':
        s = s[1:]
    
    return s



########
# Main #
########
x_primes = (2147483647, 3758096383);

print('<table>')

f = open('exceptions.txt');

i = 0
for l in f:
    i += 1
    x = int(re.search('(\d+)', l).group(0), 10)

    print(i, ':', x, file=sys.stderr)
    sys.stderr.flush()

    primaries = ([(x, 1)] if x in x_primes
                 else DSPython.factors.primaries(x))
    x_is_prime = (len(primaries) == 1) and (primaries[0][1] == 1)

    gr = DSPython.factors.nb_in_integers_4sqr(primaries)


    print("""    <tr>
      <th>{}.</th>
      <td><tt>x</tt> =</td>
      <td align="right">{} {}</td>
      <td>{}</td>
      <td>: GR(<tt>x</tt>) =</td>
      <td align="right">{}</td>
      <td>mais GR(<tt>x</tt>) modulo 2<sup>32</sup> = {}</td>
    </tr>""".format(i,
                    n_to_str(x),
                    ('<span style="visibility:hidden">=</span>' if x_is_prime
                     else '='),
                    ('' if x_is_prime
                     else ' &times; '.join([n_to_str(p) for (p, exp) in primaries])),
                    n_to_str(gr),
                    n_to_str(gr%(2**32))))
    sys.stdout.flush()

f.close()

print('</table>')
