<?php

/*
  retroLCD.php

  Olivier Pirson
  http://www.opimedia.be/

  Page PHP gnrant une page XHTML affichant l'heure sous forme LCD  7 segments
  en fonction de divers paramtres contenus dans les constantes qui suivent
*/
require_once('retroLCD.inc');

define('SIZE', 40);    // longueur (en pixel) d'un segment
define('WEIGHT', 10);  // grosseur (en pixel) d'un segment
define('DIFF', 2);     // interstice (en pixel) entre deux segments

define('COLORBG', '#002020');      // couleur du fond
define('COLOROFF', '#003030');     // couleur des segments teints
define('COLORON', 'aqua');         // couleur des segments allums
define('COLORONDARK', '#00aaaa');  // couleur des segments "spciaux" allums

define('SPACE', 20);  // espace (en pixel) entre deux symboles

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="fr">
  <!--
      retrolLCD.htm

      Olivier Pirson
      http://www.opimedia.be/

      Page XHTML affichant l'heure sous forme LCD  7 segments
         -    A
        | |  F B
         -    G
        | |  E C
         -    D
    -->
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
    <meta http-equiv="reply-to" content="olivier_pirson_opi@yahoo.fr" />

    <meta name="author" content="Olivier Pirson" />
    <meta name="date-creation-yyyymmdd" content="20100712" />
    <meta name="date-revision-yyyymmdd" content="20120609" />

    <title>retroLCD : horloge en (PHP -> XHTML/CSS)/JavaScript</title>

    <style type="text/css">
@import "retroLCD.css";

body { background-color: silver; }

h1 {
    margin-bottom: 1ex;
    margin-top: 0px;
}
h2 { margin: 0px; }

a.mail:link {
    background-color: inherit;
    color: green;
}
a.mail:visited {
    background-color: inherit;
    color: olive;
}

.center { text-align: center; }

.monospace { font-family: monospace; }

.right { text-align: right; }

.small-caps { font-variant: small-caps; }


.lcd-fig-click {
    background-color: <?php echo COLORBG; ?>;
    height: <?php echo (SIZE + SPACE)*2; ?>px;
    margin-top: 1ex;
    position: relative;
    width: <?php echo SIZE + SPACE*2; ?>px;

    -moz-border-radius: <?php echo SPACE; ?>px;
    -webkit-border-radius: <?php echo SPACE; ?>px;
    border-radius: <?php echo SPACE; ?>px;
}

.lcd-time {
    background-color: <?php echo COLORBG; ?>;
    height: <?php echo (SIZE + SPACE)*2; ?>px;
    position: relative;
    width: <?php echo (SIZE + SPACE)*9 + SPACE; ?>px;

    -moz-border-radius: <?php echo SPACE; ?>px;
    -webkit-border-radius: <?php echo SPACE; ?>px;
    border-radius: <?php echo SPACE; ?>px;
}

<?php

retroLCD_classes(0, 0, SIZE, WEIGHT, DIFF, COLOROFF);

?>

#no-javascript {
    background-color: black;
    color: red;
    display: inline;
    font-size: larger;
    font-weight: bolder;
    left: <?php echo SPACE*2; ?>px;
    padding: 2ex;
    position: relative;
    top: <?php echo SIZE; ?>px;
}
    </style>


    <script type="text/javascript" src="retroLCD.js"></script>

    <script type="text/javascript">/*<![CDATA[*/
/*
  Si n === undefined alors inverse l'tat des segments de lcd-fig-click,
  sinon inverse l'tat du segment de nom n.
  Affiche le code correspondant
  Pre: n: undefined, 'A', 'B', 'C', 'D', 'E', 'F' ou 'G'
  Result:
*/
function codeClickSegment(n) {
    code = parseInt(document.getElementById('test-code-fig').value, 10);
    if ( isNaN(code) || (code < 0) || (code > 127) ) {
        code = 0;
    }

    if ( n === undefined ) {
        code = ~code & 127;
    }
    else {
        code ^= (1 << (n.charCodeAt(0) - 'A'.charCodeAt(0)));
    }
    document.getElementById('test-code-fig').value = new String(code);

    codePrint();
}


/*
  Vrifie la validit du code saisi
  puis affiche le symbole correspondant
  Result:
*/
function codePrint() {
    code = parseInt(document.getElementById('test-code-fig').value, 10);
    if ( isNaN(code) || (code < 0) || (code > 127) ) {
        code = 0;
    }

    retroLCD_figColor('click-test', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, code);
    document.getElementById('test-code-fig').value = new String(code);
    document.getElementById('test-code-fig-bin').innerHTML = [(code&64) >>> 6, (code&32) >>> 5, (code&16) >>> 4,
                                                              (code&8) >>> 3, (code&4) >>> 2, (code&2) >>> 1, code&1,
                                                              'b'].join('');
}


/*
  Affiche l'heure hh-mm-ss
  dans les lments HTML d'identifiant retroLCD-fig-0, retroLCD-fig-1, retroLCD-fig-3, retroLCD-fig-4, retroLCD-fig-6 et retroLCD-fig-7
  Result:
*/
function printTime() {
    var d = new Date();

    hours = d.getHours();
    retroLCD_figColor('0', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, RETROLCD_FIGS[Math.floor(hours/10)]);
    retroLCD_figColor('1', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, RETROLCD_FIGS[hours%10]);

    minutes = d.getMinutes();
    retroLCD_figColor('3', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, RETROLCD_FIGS[Math.floor(minutes/10)]);
    retroLCD_figColor('4', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, RETROLCD_FIGS[minutes%10]);

    seconds = d.getSeconds();
    retroLCD_figColor('6', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, RETROLCD_FIGS[Math.floor(seconds/10)]);
    retroLCD_figColor('7', <?php echo "'", COLORON, "', '", COLOROFF, "'"; ?>, RETROLCD_FIGS[seconds%10]);
}


/*
  Initialise les zones d'affichages, affiche les symboles spciaux h, ' et ''
  puis lance le timer.
  Result:
*/
function start() {
    document.getElementById('no-javascript').style.display = 'none';

    retroLCD_figColor('2', <?php echo "'", COLORONDARK, "', '", COLOROFF, "'"; ?>, RETROLCD_h);
    retroLCD_figColor('5', <?php echo "'", COLORONDARK, "', '", COLOROFF, "'"; ?>, RETROLCD_QUOTE);
    retroLCD_figColor('8', <?php echo "'", COLORONDARK, "', '", COLOROFF, "'"; ?>, RETROLCD_DOUBLEQUOTE);

    codePrint();

    printTime();

    var timer = setInterval(printTime, 1000);
}
    /*]]>*/</script>
  </head>

  <body onload="start();">
    <h1>retroLCD&thinsp;: horloge en (PHP &rarr; XHTML/CSS)/JavaScript</h1>

    <div class="lcd-time">
<?php

for ($i = 0; $i < 9; $i++) { // affiche 9 "chiffres" LCD
    retroLCD_fig(SPACE + $i*(SIZE + SPACE), SPACE, 'retroLCD-fig-'.$i);
}

?>
      <div id="no-javascript">
        Pour visualiser l&rsquo;heure veuillez activer JavaScript&hellip;
      </div>
    </div>

    <hr />

    <h2>Zone de test</h2>
    <div>
     Cliquez sur les segments ou double-cliquez sur la zone
     pour obtenir le code correspondant au symbole
      <div class="lcd-fig-click" ondblclick="codeClickSegment();">
        <div id="retroLCD-fig-click-test" class="retroLCD-fig" style="left:<?php echo SPACE; ?>px; top:<?php echo SPACE; ?>px">
          <div class="retroLCD-A-peak-left" onclick="codeClickSegment('A');"></div><div class="retroLCD-A-hori" onclick="codeClickSegment('A');"></div><div class="retroLCD-A-peak-right" onclick="codeClickSegment('A');"></div>
          <div class="retroLCD-B-peak-top" onclick="codeClickSegment('B');"></div><div class="retroLCD-B-vert" onclick="codeClickSegment('B');"></div><div class="retroLCD-B-peak-bottom" onclick="codeClickSegment('B');"></div>
          <div class="retroLCD-C-peak-top" onclick="codeClickSegment('C');"></div><div class="retroLCD-C-vert" onclick="codeClickSegment('C');"></div><div class="retroLCD-C-peak-bottom" onclick="codeClickSegment('C');"></div>
          <div class="retroLCD-D-peak-left" onclick="codeClickSegment('D');"></div><div class="retroLCD-D-hori" onclick="codeClickSegment('D');"></div><div class="retroLCD-D-peak-right" onclick="codeClickSegment('D');"></div>
          <div class="retroLCD-E-peak-top" onclick="codeClickSegment('E');"></div><div class="retroLCD-E-vert" onclick="codeClickSegment('E');"></div><div class="retroLCD-E-peak-bottom" onclick="codeClickSegment('E');"></div>
          <div class="retroLCD-F-peak-top" onclick="codeClickSegment('F');"></div><div class="retroLCD-F-vert" onclick="codeClickSegment('F');"></div><div class="retroLCD-F-peak-bottom" onclick="codeClickSegment('F');"></div>
          <div class="retroLCD-G-peak-left" onclick="codeClickSegment('G');"></div><div class="retroLCD-G-hori" onclick="codeClickSegment('G');"></div><div class="retroLCD-G-peak-right" onclick="codeClickSegment('G');"></div>
        </div>
      </div>
      <div class="center" style="width:<?php echo SIZE + SPACE*2; ?>px">
        <label for="test-code-fig">Code</label>&thinsp;:
        <input id="test-code-fig" type="text" size="3" maxlength="3" class="monospace right" onchange="codePrint();" />
        <tt id="test-code-fig-bin"></tt>
      </div>
    </div>

    <hr />

    <div class="right">
      Ralis par
      <a class="mail" href="mailto:olivier_pirson_opi@yahoo.fr?subject=[retroLCD]">Olivier <span class="small-caps">Pirson</span></a>
      &ndash;
      <a href="http://www.opimedia.be/DS/webdev/index.htm#retroLCD"><tt>http://www.opimedia.be/DS/webdev/index.htm#retroLCD</tt></a><br />
      pour le
      <a href="http://web.developpez.com/defi/creation-innovation/horloge/">Premier dfi d&rsquo;innovation&thinsp;: cration d&rsquo;une horloge</a><br />
      du site
      <a href="http://www.developpez.com/">Developpez.com</a>
    </div>
  </body>
</html>
