/*
  retroLCD.js

  Olivier Pirson
  http://www.opimedia.be/

  Constantes et fonction JavaScript pour afficher un symbole LCD
*/


var RETROLCD_FIGS = [63, 6, 91, 79, 102, 109, 125, 7, 127, 111];  // codes des chiffres 0, 1, 2, ..., 9

var RETROLCD_h = 116;           // code du symbole h
var RETROLCD_QUOTE = 32;        // code du symbole '
var RETROLCD_DOUBLEQUOTE = 34;  // code du symbole ''



/*
  Change les couleurs des segments de l'lment d'identifiant HTML 'retroLCD-fig-' + postId en fonction de code.
  Si code === false alors teint tous les segments,
  si code === true alors allume tous les segments,
  sinon allume les segments dont le nom :
     -    A
    | |  F B
     -    G
    | |  E C
     -    D
    correspond  un bit  1 dans code : GFEDCBA.
    Par exemple : code === 6 (0000110 en binaire) allume les segments B et C, et teint les autres.
  Pre: postId: String
       colorOn: String reprsentant une couleur HTML
       colorOff: String reprsentant une couleur HTML
       code: false, true, 'A', 'B', 'C', 'D', 'E', 'F' ou 'G'
  Result:
*/
function retroLCD_figColor(postId, colorOn, colorOff, code) {
    if ( code === false )
        code = 0;
    else if ( code === true )
        code = 127;

    for (var i=0; i<7; i++) {
        var c = (code & (1 << i) ? colorOn : colorOff);

        document.getElementById('retroLCD-fig-' + postId).children[i*3 + 1].style.backgroundColor = c;
        switch ( String.fromCharCode('A'.charCodeAt(0) + i) ) {
        case 'A':
        case 'D':
        case 'G':
            document.getElementById('retroLCD-fig-' + postId).children[i*3].style.borderRightColor
                = document.getElementById('retroLCD-fig-' + postId).children[i*3 + 2].style.borderLeftColor = c;
            break;

        case 'B':
        case 'C':
            document.getElementById('retroLCD-fig-' + postId).children[i*3].style.borderRightColor
                = document.getElementById('retroLCD-fig-' + postId).children[i*3 + 2].style.borderRightColor = c;
            break;

        case 'E':
        case 'F':
            document.getElementById('retroLCD-fig-' + postId).children[i*3].style.borderLeftColor
                = document.getElementById('retroLCD-fig-' + postId).children[i*3 + 2].style.borderLeftColor = c;
            break;
        }
    }
}
