<?php

/*
  retroLCD.inc

  Olivier Pirson
  http://www.opimedia.be/

  Fonctions PHP qui crivent les dfinitions de classes CSS
  et le div HTML contenant un "chiffre" LCD
*/


/*
  Une fonction qui crit les dfinitions de classes CSS pour chaque segment A, B, C, D, E, F, G :
     -    A
    | |  F B
     -    G
    | |  E C
     -    D
    (x,y) : position absolue en pixel
    size: largeur des segments en pixel
    weight: grosseur des segments en pixel
    diff: interstice entre les pointes des segments en pixel
  Pre: $x: entier
       $y: entier
       $size: 0 <= entier
       $weight: 0 <= entier
       $diff: 0 <= entier
       $color: string reprsentant une couleur CSS
  Result: /
*/
function retroLCD_A_classes($x, $y, $size, $weight, $diff, $color) {
  $x += $diff;

  echo
'.retroLCD-fig .retroLCD-A-peak-left {
    border-width: ', $weight, 'px;
    border-right-color: ', $color, ';
    clip: rect(', $weight, 'px, auto, auto, ', $weight, 'px);
    left: ', $x - $weight, 'px;
    top: ', $y - $weight, 'px;
}
.retroLCD-fig .retroLCD-A-hori {
    background-color: ', $color, ';
    height: ', $weight, 'px;
    left: ', $x + $weight, 'px;
    top: ', $y, 'px;
    width: ', $size - 2*($diff + $weight), 'px;
}
.retroLCD-fig .retroLCD-A-peak-right {
    border-width: ', $weight, 'px;
    border-left-color: ', $color, ';
    clip: rect(', $weight, 'px, ', $weight, 'px, auto, auto);
    left: ', $x + $size - 2*$diff - $weight, 'px;
    top: ', $y - $weight, 'px;
}
';
}

function retroLCD_B_classes($x, $y, $size, $weight, $diff, $color) {
  $x += $size - $weight;
  $y += $diff;

  echo
'.retroLCD-fig .retroLCD-B-peak-top {
    border-width: ', $weight, 'px;
    border-right-color: ', $color, ';
    clip: rect(auto, auto, ', $weight, 'px, ', $weight, 'px);
    left: ', $x - $weight, 'px;
    top: ', $y, 'px;
}
.retroLCD-fig .retroLCD-B-vert {
    background-color: ', $color, ';
    height: ', $size - 2*($diff + $weight), 'px;
    left: ', $x, 'px;
    top: ', $y + $weight, 'px;
    width: ', $weight, 'px;
}
.retroLCD-fig .retroLCD-B-peak-bottom {
    border-width: ', $weight, 'px;
    border-right-color: ', $color, ';
    clip: rect(', $weight, 'px, auto, auto, ', $weight, 'px);
    left: ', $x - $weight, 'px;
    top: ', $y + $size - 2*$diff - 2*$weight, 'px;
}
';
}

function retroLCD_C_classes($x, $y, $size, $weight, $diff, $color) {
  $x += $size - $weight;
  $y += $size + $diff;

  echo
'.retroLCD-fig .retroLCD-C-peak-top {
    border-width: ', $weight, 'px;
    border-right-color: ', $color, ';
    clip: rect(auto, auto, ', $weight, 'px, ', $weight, 'px);
    left: ', $x - $weight, 'px;
    top: ', $y, 'px;
}
.retroLCD-fig .retroLCD-C-vert {
    background-color: ', $color, ';
    height: ', $size - 2*($diff + $weight), 'px;
    left: ', $x, 'px;
    top: ', $y + $weight, 'px;
    width: ', $weight, 'px;
}
.retroLCD-fig .retroLCD-C-peak-bottom {
    border-width: ', $weight, 'px;
    border-right-color: ', $color, ';
    clip: rect(', $weight, 'px, auto, auto, ', $weight, 'px);
    left: ', $x - $weight, 'px;
    top: ', $y + $size - 2*$diff - 2*$weight, 'px;
}
';
}

function retroLCD_D_classes($x, $y, $size, $weight, $diff, $color) {
  $x += $diff;
  $y += 2*$size - $weight;

  echo
'.retroLCD-fig .retroLCD-D-peak-left {
    border-width: ', $weight, 'px;
    border-right-color: ', $color, ';
    clip: rect(auto, auto, ', $weight, 'px,', $weight, 'px);
    left: ', $x - $weight, 'px;
    top: ', $y, 'px;
}
.retroLCD-fig .retroLCD-D-hori {
    background-color: ', $color, ';
    height: ', $weight, 'px;
    left: ', $x + $weight, 'px;
    top: ', $y, 'px;
    width: ', $size - 2*($diff + $weight), 'px;
}
.retroLCD-fig .retroLCD-D-peak-right {
    border-width: ', $weight, 'px;
    border-left-color: ', $color, ';
    clip: rect(auto, ', $weight, 'px, ', $weight, 'px, auto);
    left: ', $x + $size - 2*$diff - $weight, 'px;
    top: ', $y, 'px;
}
';
}

function retroLCD_E_classes($x, $y, $size, $weight, $diff, $color) {
  $y += $size + $diff;

  echo
'.retroLCD-fig .retroLCD-E-peak-top {
    border-width: ', $weight, 'px;
    border-left-color: ', $color, ';
    clip: rect(auto, ', $weight, 'px, ', $weight, 'px, auto);
    left: ', $x, 'px;
    top: ', $y, 'px;
}
.retroLCD-fig .retroLCD-E-vert {
    background-color: ', $color, ';
    height: ', $size - 2*($diff + $weight), 'px;
    left: ', $x, 'px;
    top: ', $y + $weight, 'px;
    width: ', $weight, 'px;
}
.retroLCD-fig .retroLCD-E-peak-bottom {
    border-width: ', $weight, 'px;
    border-left-color: ', $color, ';
    clip: rect(', $weight, 'px, ', $weight, 'px, auto, auto);
    left: ', $x, 'px;
    top: ', $y + $size - 2*$diff - 2*$weight, 'px;
}
';
}

function retroLCD_F_classes($x, $y, $size, $weight, $diff, $color) {
  $y += $diff;

  echo
'.retroLCD-fig .retroLCD-F-peak-top {
    border-width: ', $weight, 'px;
    border-left-color: ', $color, ';
    clip: rect(auto, ', $weight, 'px, ', $weight, 'px, auto);
    left: ', $x, 'px;
    top: ', $y, 'px;
}
.retroLCD-fig .retroLCD-F-vert {
    background-color: ', $color, ';
    height: ', $size - 2*($diff + $weight), 'px;
    left: ', $x, 'px;
    top: ', $y + $weight, 'px;
    width: ', $weight, 'px;
}
.retroLCD-fig .retroLCD-F-peak-bottom {
    border-width: ', $weight, 'px;
    border-left-color: ', $color, ';
    clip: rect(', $weight, 'px, ', $weight, 'px, auto, auto);
    left: ', $x, 'px;
    top: ', $y + $size - 2*$diff - 2*$weight, 'px;
}
';
}

function retroLCD_G_classes($x, $y, $size, $weight, $diff, $color) {
  $x += $diff;
  $y += $size - $weight/2;

  echo
'.retroLCD-fig .retroLCD-G-peak-left {
    border-width: ', $weight/2, 'px;
    border-right-color:  ', $color, ';
    clip: rect(auto, auto, auto, ', $weight/2, 'px);
    left: ', $x - $weight/2, 'px;
    top: ', $y, 'px;
}
.retroLCD-fig .retroLCD-G-hori {
    background-color: ', $color, ';
    height: ', $weight, 'px;
    left: ', $x + $weight/2, 'px;
    top: ', $y, 'px;
    width: ', $size - 2*$diff - $weight, 'px;
}
.retroLCD-fig .retroLCD-G-peak-right {
    border-width: ', $weight/2, 'px;
    border-left-color: ', $color, ';
    clip: rect(auto, ', $weight/2, 'px, auto, auto);
    left: ', $x + $size - 2*$diff - $weight/2, 'px;
    top: ', $y, 'px;
}
';
}


/*
  Ecrit les dfinitions de classes CSS pour tous les segments
    (x,y) : position absolue en pixel
    size: largeur des segments en pixel
    weight: grosseur des segments en pixel
    diff: interstice entre les pointes des segments en pixel
  Pre: $x: integer
       $y: integer
       $size: 0 <= integer
       $weight: 0 <= integer
       $diff: 0 <= integer
       $color: string reprsentant une couleur CSS
  Result: /
*/
function retroLCD_classes($x, $y, $size, $weight, $diff, $color) {
  retroLCD_A_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
  retroLCD_B_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
  retroLCD_C_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
  retroLCD_D_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
  retroLCD_E_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
  retroLCD_F_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
  retroLCD_G_classes($x, $y, $size, $weight, $diff, $color);
  echo "\n";
}


/*
  Ecrit un div HTML d'identifiant $id
  et positionn de faon absolue en ($x px, $y px)
  Pre: $x: integer
       $y: integer
       $id: string
  Result: /
*/
function retroLCD_fig($x, $y, $id) {
  echo
'<div id="', $id, '" class="retroLCD-fig" style="left:', $x, 'px; top:', $y, 'px">
  <div class="retroLCD-A-peak-left"></div><div class="retroLCD-A-hori"></div><div class="retroLCD-A-peak-right"></div>
  <div class="retroLCD-B-peak-top"></div><div class="retroLCD-B-vert"></div><div class="retroLCD-B-peak-bottom"></div>
  <div class="retroLCD-C-peak-top"></div><div class="retroLCD-C-vert"></div><div class="retroLCD-C-peak-bottom"></div>
  <div class="retroLCD-D-peak-left"></div><div class="retroLCD-D-hori"></div><div class="retroLCD-D-peak-right"></div>
  <div class="retroLCD-E-peak-top"></div><div class="retroLCD-E-vert"></div><div class="retroLCD-E-peak-bottom"></div>
  <div class="retroLCD-F-peak-top"></div><div class="retroLCD-F-vert"></div><div class="retroLCD-F-peak-bottom"></div>
  <div class="retroLCD-G-peak-left"></div><div class="retroLCD-G-hori"></div><div class="retroLCD-G-peak-right"></div>
</div>
';
}

?>