#!/usr/bin/env python
# -*- coding: latin-1 -*-

# Cre les fichiers PHP :
#   html_entities_entitydefs.js
#   html_entities_name2codepoint.js
#   html_entities_codepoint2name.js

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# 2012 October 15
####################################

import html.entities


l = []
for k in sorted(html.entities.entitydefs):
    l.append('\'' + k + '\': \'' + html.entities.entitydefs[k] + '\'')

f = open('html_entities_entitydefs.js', mode='w', encoding='utf_8', newline='\n')

print("""/* -*- coding: utf-8 -*- */

/**
  Table associative : nom d'entitit XHTML: caractre correspondant.
  Par ex. : 'eacute': ''.
  (Cf. http://docs.python.org/py3k/library/html.entities.html#module-html.entities
  "A dictionary mapping XHTML 1.0 entity definitions to their replacement text in ISO Latin-1.")

  (c) Olivier Pirson --- DragonSoft
  http://www.opimedia.be/DS/
*/
var HTML_ENTITIES_ENTITYDEFS = {
    """ + ', '.join(l) + """
};""", file=f);

f.close()



l = []
for k in sorted(html.entities.name2codepoint):
    l.append('\'' + k + '\': ' + str(html.entities.name2codepoint[k]))

f = open('html_entities_name2codepoint.js', mode='w', encoding='utf_8', newline='\n')

print("""/* -*- coding: utf-8 -*- */

/**
  Table associative : nom d'entitit XHTML: code du caractre correspondant.
  Par ex. : 'eacute': 233.
  (Cf. http://docs.python.org/py3k/library/html.entities.html#module-html.entities
  "A dictionary that maps HTML entity names to the Unicode codepoints.")

  (c) Olivier Pirson --- DragonSoft
  http://www.opimedia.be/DS/
*/
var HTML_ENTITIES_NAME2CODEPOINT = {
    """ + ', '.join(l) + """
};""", file=f);

f.close()



l = []
for k in sorted(html.entities.codepoint2name):
    l.append(str(k) + ': \'' + html.entities.codepoint2name[k] + '\'')

f = open('html_entities_codepoint2name.js', mode='w', encoding='utf_8', newline='\n')

print("""/* -*- coding: utf-8 -*- */

/**
  Table associative : code d'un caractre: nom de l'entitit XHTML correspondante.
  Par ex. : 233: 'eacute'.
  (Cf. http://docs.python.org/py3k/library/html.entities.html#module-html.entities
  "A dictionary that maps Unicode codepoints to HTML entity names.")

  (c) Olivier Pirson --- DragonSoft
  http://www.opimedia.be/DS/
*/
var HTML_ENTITIES_CODEPOINT2NAME = {
    """ + ', '.join(l) + """
};""", file=f);

f.close()
