#!/usr/bin/env python
# -*- coding: latin-1 -*-

# Cre les fichiers JavaScript :
#   accentalpha_to_alpha.js
#   greek_to_alpha.js

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# 2012 October 15
####################################

import html.entities
import re


l = []
for k in html.entities.entitydefs:
    r = re.match('([A-Za-z])(?:acute|caron|cedil|circ|grave|ring|slash|tilde|uml)', k)
    if ( r ):
        c = r.group(1)
    else:
        r = re.match('([A-Za-z][A-Za-z])lig', k)
        if ( r ):
            c = r.group(1)
        else:
            continue

    l.append('\'' + html.entities.entitydefs[k] + '\': \'' + c + '\'')

f = open('accentalpha_to_alpha.js', mode='w', encoding='utf_8', newline='\n')

print("""/* -*- coding: utf-8 -*- */

/**
  Table associative : caractre avec accent, cdille... ou ligature: caractre alphabtique correspondant.
  Par ex. : '': 'e'.

  (c) Olivier Pirson --- DragonSoft
  http://www.opimedia.be/DS/
*/
var ACCENTALPHA_TO_ALPHA = {
    """ + ', '.join(sorted(l)) + """
};""", file=f);

f.close()



l = []
for i in range(913, 970):
    if ( (i == 930) or (938 <= i <= 944) ):
        continue

    if  i in (914, 946) :
        c = 'v'
    elif  i in (919, 951) :
        c = 'i'
    elif  i in (933, 965) :
        c = 'y'
    elif  i in (934, 966) :
        c = 'f'
    else:
        c = html.entities.codepoint2name[i][0:(2 if i in (920, 935, 936,
                                                          952, 967, 968)
                                           else 1)]
    if ( i <= 937 ):
        c = c.upper()
    l.append('\'' + chr(i) + '\': \'' + c + '\'')

l.append('\'' + chr(977) + '\': \'th\'')
l.append('\'' + chr(978) + '\': \'y\'')
l.append('\'' + chr(982) + '\': \'p\'')

f = open('greek_to_alpha.js', mode='w', encoding='utf_8', newline='\n')

print("""/* -*- coding: utf-8 -*- */

/**
  Table associative : lettre grecque: caractre alphabtique romain correspondant.
  Par ex. : caractre de la lettre grecque epsilon: 'e'.

  Adopte la norme ONU/ELOT : cf. http://www.opimedia.be/DS/mementos/grecs.htm

  (c) Olivier Pirson --- DragonSoft
  http://www.opimedia.be/DS/
*/
var GREEK_TO_ALPHA = {
    """ + ', '.join(sorted(l)) + """
};""", file=f);

f.close()
