/* Mandel
 *   Calcule l'ensemble de Mandelbrot
 *   et sauve l'image dans "Mandel.ppm"
 * (c) Olivier Pirson --- DragonSoft
 * http://www.opimedia.be/DS/
 * Dbut le 14 aot 2009
 * v.01.00 --- 30 octobre 2009
 *         --- 2 janvier 2012 : nouveau site web
 ************************************************/
#define VERSION "v.01.00 --- 2012 January 2"

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>



/*********************
 * Macros constantes *
 *********************/
/* Largeur de l'image */
#define WIDTH 500

/* Hauteur de l'image */
#define HEIGHT 500



/************
 * Fonction *
 ************/
/* Calcule une image de taille WIDTH x HEIGHT de l'ensemble de Mandelbrot
   et la sauve dans le fichier "Mandel.ppm"
   pre: max_ite: nombre maximum d'itrations (pour chaque point),
        black: noir&blanc, sinon en niveau gris */
void mandelbrot_set(unsigned int max_ite, bool black) {
  FILE
    *file = fopen("Mandel.ppm", "wb");  /* fichier binaire ouvert en criture */

  const double
    /* Coin suprieur droit */
    z0_real = -2,
    z0_imag = 2,

    /* Coin infrieur gauche */
    z1_real = 2,
    z1_imag = -2,

    /* Coefficients pour calculer les coordonnes correspondant aux pixels */
    COEF_C_real = (z1_real - z0_real)/(WIDTH - 1),
    COEF_C_imag = (z0_imag - z1_imag)/(HEIGHT - 1);

  unsigned int
    y;


  fprintf(file, "P6\n%u %u\n255\n", WIDTH, HEIGHT);  /* en-tte de l'image au format PPM */

  /* Calcule chaque pixel de l'image, ligne par ligne */
  for(y=0; y<HEIGHT; y++) {
    const double
      C_imag = z0_imag - COEF_C_imag*y;

    unsigned int
      x;

    for(x=0; x<WIDTH; x++) {
      const double
        C_real = z0_real + COEF_C_real*x;

      /* On va itrer la fonction pour le point complexe C_real + i.C_imag */
      double
        z_real = C_real,
        z_imag = C_imag,
        z_abs2 = 0;  /* carr du module de z */

      unsigned int
        nb_ite;  /* nombre d'itrations */

      for (nb_ite=0; nb_ite<max_ite; nb_ite++)  {
        const double
          z_real2 = z_real*z_real,
          z_imag2 = z_imag*z_imag;

        z_abs2 = z_real2 + z_imag2;
        if (z_abs2 > 4)
          break;

        z_imag = z_imag*z_real*2 + C_imag;
        z_real = z_real2 - z_imag2 + C_real;
      }
      {
        const unsigned int
          c = ((z_abs2 <= 4)
               ? 0
               : (black
                  ? 255
                  : 255 - nb_ite*254/max_ite));
        fputc(c, file);  /* rouge */
        fputc(c, file);  /* vert */
        fputc(c, file);  /* bleu */
      }
    }
  }

  fclose(file);
}



/********
 * Main *
 ********/
int main(int argc, const char *argv[]) {
  fputs("Mandel --- " VERSION "\n"
        "--- Begin calculation... ", stderr);
  fflush(stderr);

  mandelbrot_set(50, false);

  fputs("end ---\n", stderr);
  return EXIT_SUCCESS;
}
