/*
  Deterministic Notes
  ===================
  Generate sequence of notes, depending of a step parameter.
  Click on canvas to change this step parameter and/or speed.

  See http://reglos.de/musinum/ for explanation of rules used.

  Images from http://archive.org/details/Prelude_559 .

  Programming with http://www.processing.org/
  to https://www.coursera.org/course/digitalmedia course.

  Author: Olivier Pirson
  Personal website: http://www.opimedia.be/
  Portfolio on OpenProcessing: http://www.openprocessing.org/user/29359
 */

Maxim maxim = new Maxim(this);

AudioPlayer [] notes = new AudioPlayer[7];
AudioPlayer current_note;

int musinum_n = 7;
int musinum_step = 3;

float NOTE_DELAY_STOP = 15;
float note_delay = 0;


/* Movie images */
PImage [] images = new PImage[135];

float IMAGE_DELAY_STOP = 5;
float image_delay = 0;

int current_image_num = 0;


/* Speed parameter */
float speed = 1;



/* Load sounds and images, and init */
void setup() {
  /* Sounds */
  notes[0] = maxim.loadFile("notes/C.wav");
  notes[1] = maxim.loadFile("notes/D.wav");
  notes[2] = maxim.loadFile("notes/E.wav");
  notes[3] = maxim.loadFile("notes/F.wav");
  notes[4] = maxim.loadFile("notes/G.wav");
  notes[5] = maxim.loadFile("notes/A.wav");
  notes[6] = maxim.loadFile("notes/B.wav");

  for (int i=0; i<notes.length; i++) {
    notes[i].setAnalysing(true);
  }

  current_note = notes[0];

  /* Images */
  for (int i=0; i<images.length; i++) {
    String num = str(i);

    while ( num.length() < 3 ) {
      num = "0" + num;
    }
    images[i] = loadImage("riders/riders_" + num + ".jpg");
  }


  /* size(images[0].width + 20, images[0].height + 20); */
  size(320, 320);
}


/* Update note and image, and draw all. */
void draw() {
  if ( note_delay < NOTE_DELAY_STOP ) {
    note_delay += speed;
  }
  else {
    note_delay = note_delay%NOTE_DELAY_STOP + speed;

    current_note.stop();

    musinum_n += pow(2, musinum_step) - 1;

    current_note = musinum_n_to_note(musinum_n);

    current_note.cue(10);
    current_note.play();
  }

  if ( image_delay < IMAGE_DELAY_STOP ) {
    image_delay += speed*2;
  }
  else {
    image_delay = image_delay%IMAGE_DELAY_STOP + speed;
    current_image_num = (current_image_num + 1)%images.length;
  }

  background(0);

  image(images[current_image_num], 0, 0);

  stroke(46, 133, 142);
  strokeWeight(1);
  fill(46, 133, 142);
  rect(width - 20, floor(map(musinum_step, 1, 8.99, height - 20, 0)), 20, -(height - 20)/8);

  stroke(128);
  for (int i=2; i<9; i++) {
    int y = floor(map(i, 1, 8.99, height - 20, 0));

    line(width - 20, y, width, y);
  }

  int x = floor(map(speed, 0.5, 1.5, 0, width - 20));

  stroke(46, 133, 142);
  strokeWeight(3);
  line(x, height - 20, x, height);

  textSize(18);

  fill(255);
  textAlign(CENTER);
  text("Speed", width/2, height - 3);

  text("S", width - 10, height/2 - 28);
  text("t", width - 10, height/2 - 11);
  text("e", width - 10, height/2 + 5);
  text("p", width - 10, height/2 + 20);
}


/* Change step parameter and/or speed. */
void mouseDragged() {
  mousePressed();
}


/* Change step parameter and/or speed. */
void mousePressed() {
  if ( (0 <= mouseX) && (mouseX < width - 20) ) {
    speed = map(mouseX, 0, width - 20, 0.5, 1.5);
  }
  if ( (0 <= mouseY) && (mouseY < height - 20) ) {
    musinum_step = floor(map(mouseY, 0, height - 20, 8.99, 1));
  }
}


/* Convert n to AudioPlayer note */
AudioPlayer musinum_n_to_note(int n) {
  int note = -1;

  while (n > 0) {  // sum of bits
    if ( (n&1) == 1 ) {
      note++;
    }
    n /= 2;
  }

  return notes[note%notes.length];
}

