#!perl

###################################################################################
# space.pl                                                                        #
# Lit le fichier du premier argument et le renvoie sur la sortie standard.        #
# Pour chaque ligne strictement comprise entre <body et </body> (ignore la case), #
#   remplace chaque espace de dbut ou de fin de ligne par un &nbsp;              #
#   et chaque double espace par &nbsp;&nbsp;                                      #
# (c) Olivier Pirson --- DragonSoft                                               #
# Dbut le 23 juillet 2000                                                       #
#   v.00.01.00 --- 22 juin 2001                                                   #
###################################################################################
$version = "v.00.01.00 --- 22 june 2001";

$inBody = 0;  # true ssi entre <body et </body>

while ( <> ) {
    chomp;
    if ( /<\/body>/i ) { $inBody = 0; }

    if ( $inBody ) {
        s/\s\s/&nbsp;&nbsp;/g;     # remplace chaque double espace par &nbsp;&nbsp;
        s/^\s/&nbsp;/;             # remplace chaque espace de dbut par &nbsp;
        s/\s$/&nbsp;/;             # remplace chaque espace de fin par &nbsp;
        s/<c>/<center>/g;          # remplace chaque <c> par <center>
        s/<\/c>/<\/center>/g;      # remplace chaque <\c> par <\center>
        s/<s>/<sup>/g;             # remplace chaque <s> par <sup>
        s/<\/s>/<\/sup>/g;         # remplace chaque <\s> par <\sup>
    } # if
    print $_."\n";

    if ( /<body/i ) { $inBody = 1; }
} # while

exit(0); # ;-)
