#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\file
# Application <b>URM of Cutland Tk</b> permettant de manipuler
# une URM de <span style="font-variant:small-caps">Cutland</span>
# !!! Work in progress !!!
#
# \htmlonly <a class="relative" href="urmCutlandTk.png" target="_blank"><img
#   src="urmCutlandTk_th.png" border="0" align="top" alt="[urmCutlandTk_th.png]"></a>\endhtmlonly\n
# Cf. \htmlonly <a href="http://www.opimedia.be/Bruno_Marchal/index.htm#Theo" target="_blank">
#   <tt>http://www.opimedia.be/Bruno_Marchal/index.htm#Theo</tt></a>\endhtmlonly


# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 24 janvier 2008
# v.00.00 --- 2 mars 2008
#         --- 19 mai 2008
#         --- 20 novembre 2008
#         --- 26 fvrier 2009
#         --- 25 mars 2009
#         --- 29 septembre 2009 : nouveau site web
#         --- 14 dcembre 2009 : from __future__ import division
#         --- 20 dcembre 2009 : adapte pour Python 3
#         --- 16 mars 2010 : nouveau site web et changement des % en .format()
#         --- 12 avril 2010 : cfr. -> cf.
###############################################################################
from __future__ import division

## Version
VERSION = 'v.00.00 --- 2010 April 12'

import sys, time

if sys.version_info[0] >= 3:  # Python >= 3
    import tkinter as tk
    import tkinter.font as tkFont
    import tkinter.messagebox as tkMessageBox
else:                         # 2.6 <= Python < 3
    import Tkinter as tk
    import tkFont
    import tkMessageBox

import DSPython
import DSPython.factors as factors
import DSPython.urmCutland as urmCutland

try:
    if not 'profile' in dir():
        import psyco
        psyco.full()
except ImportError:
    pass



# ####################
# Variables globales #
######################
## Reprsentation du programme par un code  la Gdel
godel_prog = 1

## Reprsentation des registres par un code  la Gdel
godel_regs = 1

## Nombre d'instructions excute
nb_runned = 0

## Numro de l'instruction courante
num_inst = 1

## Numro de l'instruction courante prcdante
num_inst_old = None

## Numro du registre courant
num_reg = 1

## Numro du registre courant prcdant
num_reg_old = None

## Programme  faire excuter par urm
prog = urmCutland.UrmCutlandProg('')

## Machine virtuelle URM
urm = urmCutland.UrmCutland()



# #####################################
# Variables globales pour l'interface #
#######################################
## Fentre principale
w = tk.Tk()

## Police de caractres  taille fixe pour les listes
monospace = tkFont.Font(w, size=10, family='courier')

## Si True alors n'affiche pas les instructions q) J(m,n,q+1) dans le champ programme
hide_qJmnq1 = tk.IntVar()
hide_qJmnq1.set(1)

## Si True alors n'affiche pas les instructions T(n,n) dans le champ programme
hide_Tnn = tk.IntVar()
hide_Tnn.set(1)

## Si True alors affiche les "nombres de Gdel" de chaque instruction
show_godel_numbers = tk.IntVar()

## Si True alors affiche godel_prog
show_godel_prog = tk.IntVar()

## Si True alors affiche godel_regs
show_godel_regs = tk.IntVar()

## Si True alors affiche les facteurs des registres
show_factors = tk.IntVar()
show_factors.set(1)


## Si True alors marque une pause entre chaque instruction excute
sleep = tk.IntVar()

## Dure en ms de l'attente en deux excutions
sleep_delay = 100


## Si True alors interrompre l'excution en cours
stop = False



# ###########
# Fonctions #
#############
## Compile le source
def compile():
    """???"""
    global nb_runned, num_inst, prog

    src = str(l_src.get('1.0', tk.END))
    try:
        prog = urmCutland.UrmCutlandProg(src)
    except:
        prog = urmCutland.UrmCutlandProg('')
    num_inst = 1
    nb_runned = 0

    update_num_inst()
    update_nb_runned()
    update_prog()


# Renvoie l'instruction numro num sous forme de String
def inst_to_str(num):
    """???"""
    global hide_qJmnq1, hide_Tnn, num_inst, prog, show_godel_numbers

    c = ('*' if num == num_inst
         else ' ')
    if ((hide_Tnn.get() and (prog[num].inst() == urmCutland.T)
         and (prog[num].a() == prog[num].b()))
        or (hide_qJmnq1.get() and (prog[num].inst() == urmCutland.J)
            and (prog[num].c() == num + 1))):
        s = num_inst_to_str(num)
    else:
        s = '{0}{1}'.format(num_inst_to_str(num), prog[num])
    if show_godel_numbers.get():
        s += ' = {0}'.format(prog[num].godelnumber())
    return s


## Renvoie un numro d'instruction sous forme de String
def num_inst_to_str(num):
    """???"""
    global num_inst, prog

    return ('{{0:{0}}}){{1}}'.format(len(str(len(prog))))).format(num,
                                                                  '*' if num == num_inst
                                                                  else ' ')


## Excute certaines instructions du programme dans l'URM
def run(nb):
    """Excute nb (ou toutes si nb == None) instructions du programme dans l'URM

    Pre: nb: naturel ou None"""
    global nb_runned, num_inst, prog, stop

    b_run.config(relief=tk.SUNKEN, state=tk.DISABLED)
    stop = False
    while ((nb == None) or (nb > 0)) and (num_inst <= len(prog)) and (not stop):
        update_num_inst()
        update_nb_runned()
        update_registers()
        w.update()
        if sleep.get():
            time.sleep(sleep_delay/1000)

        num_inst = urm.run(prog, i=num_inst, nb=1)[0]
        nb_runned += 1
        if nb != None:
            nb -= 1

    stop = False
    update_num_inst()
    update_nb_runned()
    update_registers()
    b_run.config(relief=tk.RAISED, state=tk.NORMAL)



# ############################
# Fonctions pour l'interface #
##############################
## MessageBox About...
def cmd_about():
    tkMessageBox.showinfo('About...',
                          """URM of Cutland Tk

!!! Work in progress !!!
{0}
(c) Olivier Pirson --- DragonSoft
{1}


Infos:
{2}
Python {3}""".format(VERSION, DSPython.DS_web, DSPython.VERSION, sys.version))


## Efface les registres
def cmd_clear_regs():
    global urm

    urm = urmCutland.UrmCutland()
    update_registers()


## Efface le source (et donc le programme)
def cmd_clear_src():
    global l_prog, l_src

    l_prog.delete(0, tk.END)
    l_src.delete('1.0', tk.END)


## Compile le source et actualise l'affichage
def cmd_compile():
    compile()


## cmd_compile() puis cmd_run()
def cmd_compile_run():
    cmd_compile()
    cmd_run()


## Excute le reste du programme  partir de l'instruction courante
def cmd_finish():
    run(None)


## Rcupre et actualise le numro d'instruction courante
def cmd_num_inst(event):
    global num_inst

    try:
        n = int(str(event.widget.get()))
        num_inst = max(1, n)
    except:
        pass
    update_num_inst()


## Quitter ?
def cmd_quit():
    if tkMessageBox.askyesno('Quit?', 'Quit URM of Cutland Tk?'):
        cmd_stop()
        w.quit()


## Rinitialise sur la premire instruction
def cmd_restart():
    global num_inst, nb_runned

    num_inst = 1
    nb_runned = 0
    update_num_inst()
    update_nb_runned()


## Excute tout le programme aprs rinitialisation
def cmd_run():
    global num_inst, urm

    urm = urmCutland.UrmCutland()
    num_inst = 1
    run(None)


## Slection d'une instruction
def cmd_select_inst(event):
    global l_prog, num_inst

    i = l_prog.curselection()
    num_inst = (int(i[0]) + 1 if len(i) > 0
                else 1)
    update_num_inst()


## Initialise sleep_delay avec la valeur saisie
def cmd_change_delay(event):
    global e_delay, sleep_delay

    s = e_delay.get()
    try:
        sleep_delay = int(s)
    except:
        e_reg.delete(0, tk.END)


## Initialise num_reg avec la valeur saisie
def cmd_change_reg(event):
    global e_reg, num_reg, urm

    s = e_reg.get()
    if (s != '') and (s[-1] == ':'):  # numro de registre
        try:
            num_reg = max(1, int(s[:-1]))
            e_reg.delete(0, tk.END)
            update_num_reg()
        except:
            e_reg.delete(0, tk.END)
            e_reg.insert(tk.END, ':')
    else:                             # valeur pour le registre
        try:
            n = int(s)
            if n >= 0:
                urm[num_reg] = n
                update_registers()
            else:
                e_reg.delete(0, tk.END)
        except:
            e_reg.delete(0, tk.END)
    update_registers()


## Slection d'un registre
def cmd_select_reg(event):
    global l_regs, num_reg

    i = l_regs.curselection()
    num_reg = (int(i[0]) + 1 if len(i) > 0
               else 1)
    update_num_reg()


## Excute l'instruction courante
def cmd_step():
    run(1)


## Active le stop
def cmd_stop():
    global stop

    stop = True


## Ractualise l'affichage de godel_prog
def update_godel_prog():
    global godel_prog, l_godel_prog, prog

    if show_godel_prog.get():
        godel_prog = prog.godelnumber()
        l_godel_prog.config(text=('{0}' if godel_prog < 10**20
                                  else '{0:e}').format(godel_prog))
    else:
        l_godel_prog.config(text='')


## Ractualise l'affichage de godel_regs
def update_godel_regs():
    global godel_regs, l_godel_regs, urm

    if show_godel_regs.get():
        godel_regs = urm.godelnumber()
        l_godel_regs.config(text=('{0}' if godel_regs < 10**20
                                  else '{0:e}').format(godel_regs))
    else:
        l_godel_regs.config(text='')


## Ractualise l'affichage de nb_runned
def update_nb_runned():
    global l_nb_runned, nb_runned

    l_nb_runned.config(text='{0} runned'.format(nb_runned))


## Ractualise l'affichage de num_inst
def update_num_inst():
    global l_inst, num_inst, num_inst_old

    if num_inst_old == num_inst:
        return
    if (num_inst_old != None) and (num_inst_old <= l_prog.size()):
        l_prog.delete(num_inst_old - 1)
        l_prog.insert(num_inst_old - 1, inst_to_str(num_inst_old))
    if num_inst <= l_prog.size():
        l_prog.delete(num_inst - 1)
        l_prog.insert(num_inst - 1, inst_to_str(num_inst))
    num_inst_old = num_inst
    l_inst.config(text=num_inst_to_str(num_inst))


## Ractualise l'affichage de num_reg
def update_num_reg():
    global l_reg, num_reg, urm

    l_reg.config(text=('{{0:{0}}}'.format(len(str(len(urm))))).format(num_reg))


## Ractualise l'affichage de prog
def update_prog():
    global l_prog, num_inst, num_inst_old, prog

    l_prog.delete(0, tk.END)
    for i in range(1, len(prog) + 1):
        l_prog.insert(tk.END, inst_to_str(i))
    num_inst_old = num_inst

    update_num_inst()
    update_nb_runned()
    update_godel_prog()


## Ractualise l'affichage des registres
def update_registers():
    global l_regs, show_factors, urm

    len_r = 0
    for r in urm:
        len_r = max(len_r, r)
    len_r = len(str(len_r))

    l_regs.delete(0, tk.END)
    for i in range(1, len(urm) + 1):
        if show_factors.get() and (urm[i] > 0):
            p = factors.primaries(urm[i])
            s = (('{{0:{0}}}: {{1:{1}}} = {{2}}'.format(len(str(len(urm))), len_r))
                 .format(i, urm[i], factors.primaries_str(p, times=' .')))
            if len(s) > 30:
                s = (('{{0:{0}}}: {{1:{1}}} = {{2}}'.format(len(str(len(urm))), len_r))
                     .format(i, urm[i], factors.primaries_str(p)))
        else:
            s = ('{{0:{0}}}: {{1:{1}}}'.format(len(str(len(urm))), len_r)).format(i, urm[i])
        l_regs.insert(tk.END, s)

    update_num_reg()
    update_godel_regs()



# ######\cond MAIN
# Main #
########
w.title('URM of Cutland Tk   (!!! Work in progress !!!)')
w.resizable(0,0)
w.protocol('WM_DELETE_WINDOW', cmd_quit)


# ------
## Pour les premiers boutons
f = tk.Frame(w)

## Bouton 'Compile & Run'
b_run = tk.Button(f, text='Compile & Run', command=cmd_compile_run)
b_run.grid(row=1, column=1)
tk.Frame(f, width=5).grid(row=1, column=2)
tk.Button(f, text='Restart', command=cmd_restart).grid(row=1, column=5)
tk.Frame(f, width=5).grid(row=1, column=6)

tk.Button(f, text='Step', command=cmd_step).grid(row=1, column=7)
tk.Button(f, text='Next', state=tk.DISABLED).grid(row=1, column=8)
tk.Button(f, text='Continue', state=tk.DISABLED).grid(row=1, column=9)
tk.Button(f, text='Finish', command=cmd_finish).grid(row=1, column=10)
tk.Frame(f, width=5).grid(row=1, column=11)
tk.Button(f, text='Stop', command=cmd_stop).grid(row=1, column=12)

tk.Frame(f, width=20).grid(row=1, column=13)
tk.Button(f, text='Help', state=tk.DISABLED).grid(row=1, column=14)
tk.Button(f, text='About', command=cmd_about).grid(row=1, column=15)
tk.Frame(f, width=5).grid(row=1, column=16)
tk.Button(f, text='Quit', command=cmd_quit).grid(row=1, column=17)

f.grid(row=1, column=1, sticky=tk.W)

tk.Frame(f, height=5).grid(row=2, column=1)



# ------
## Pour les registres et le programme
f = tk.Frame(w)

tk.Button(f, text='Load', state=tk.DISABLED).grid(row=1, column=1, sticky=tk.W)
tk.Button(f, text='Save', state=tk.DISABLED).grid(row=1, column=2, sticky=tk.W)
tk.Button(f, text='Clear', command=cmd_clear_regs).grid(row=1, column=3, sticky=tk.W)
tk.Frame(f, height=5).grid(row=2, column=1)

## Liste des registres
l_reg = tk.Label(f, text='', font=monospace)
l_reg.grid(row=3, column=1, sticky=tk.W)

## Entry pour change la valeur d'un registre
e_reg = tk.Entry(f, width=5, font=monospace)
e_reg.bind('<Return>', cmd_change_reg)
#???e_reg.bind('<FocusOut>', cmd_change_reg)
e_reg.grid(row=3, column=2, sticky=tk.W)

tk.Label(f, text='Registers |').grid(row=3, column=3, sticky=tk.E)

## Listbox pour la liste des regitres
l_regs = tk.Listbox(f, height=20, width=30, font=monospace)
l_regs.bind('<ButtonRelease-1>', cmd_select_reg)
l_regs.grid(row=4, column=1, columnspan=3, sticky=tk.N)

tk.Checkbutton(f, text="Gdel's number:", variable=show_godel_regs,
               command=update_godel_regs).grid(row=5, column=1, sticky=tk.W)
## Label pour le nombre de Gdel de la liste des registres
l_godel_regs = tk.Label(f, text=godel_regs)
l_godel_regs.grid(row=5, column=2, columnspan=2, sticky=tk.W)

tk.Checkbutton(f, text='Show factors', variable=show_factors,
               command=update_registers).grid(row=6, column=1, columnspan=3, sticky=tk.W)


tk.Button(f, text='Load', state=tk.DISABLED).grid(row=1, column=4, sticky=tk.W)
tk.Button(f, text='Save', state=tk.DISABLED).grid(row=1, column=5, sticky=tk.W)
tk.Button(f, text='Run', command=cmd_run).grid(row=1, column=6, sticky=tk.W)
tk.Frame(f, height=5).grid(row=2, column=4)

## Programme (liste des instructions)
l_inst = tk.Label(f, text=num_inst_to_str(num_inst), font=monospace)
l_inst.grid(row=3, column=4, sticky=tk.W)

## Label pour le nombre d'instructions excutes
l_nb_runned = tk.Label(f, text='{0} runned'.format(nb_runned))
l_nb_runned.grid(row=3, column=5, sticky=tk.W)

tk.Label(f, text='Program |').grid(row=3, column=6, sticky=tk.E)

## Listbox pour le programme
l_prog = tk.Listbox(f, height=20, width=25, font=monospace)
l_prog.bind('<ButtonRelease-1>', cmd_select_inst)
l_prog.grid(row=4, column=4, columnspan=3, sticky=tk.N)

tk.Checkbutton(f, text="Gdel's number:", variable=show_godel_prog,
               command=update_godel_prog).grid(row=5, column=4, sticky=tk.W)
## Label pour le nombre de Gdel du programme
l_godel_prog = tk.Label(f, text=godel_prog)
l_godel_prog.grid(row=5, column=5, columnspan=2, sticky=tk.W)

tk.Checkbutton(f, text="Show Gdel's numbers", variable=show_godel_numbers,
               command=update_prog).grid(row=6, column=4, columnspan=3, sticky=tk.W)

tk.Checkbutton(f, text='Hide', variable=hide_Tnn,
               command=update_prog).grid(row=7, column=4, columnspan=1, sticky=tk.W)
tk.Label(f, text='T(n,n)', font=monospace).grid(row=7, column=5, columnspan=2, sticky=tk.W)

tk.Checkbutton(f, text='Hide', variable=hide_qJmnq1,
               command=update_prog).grid(row=8, column=4, columnspan=3, sticky=tk.W)
tk.Label(f, text='q) J(m,n,q+1)', font=monospace).grid(row=8, column=5, columnspan=2, sticky=tk.W)

tk.Checkbutton(f, text='Delay:', variable=sleep,
               command=lambda : cmd_change_delay(None)).grid(row=9, column=4,
                                                             columnspan=3, sticky=tk.W)
## Entry pour le dlai
e_delay = tk.Entry(f, width=5)
e_delay.insert(tk.END, str(sleep_delay))
e_delay.bind('<Return>', cmd_change_delay)
#???e_delay.bind('<FocusOut>', cmd_change_delay)
e_delay.grid(row=9, column=5, sticky=tk.W)
tk.Label(f, text='ms').grid(row=9, column=6, sticky=tk.W)


tk.Button(f, text='Load', state=tk.DISABLED).grid(row=1, column=7, sticky=tk.W)
tk.Button(f, text='Save', state=tk.DISABLED).grid(row=1, column=8, sticky=tk.W)
tk.Button(f, text='Clear', command=cmd_clear_src).grid(row=1, column=9, sticky=tk.N)
tk.Button(f, text='Compile', command=cmd_compile).grid(row=1, column=10, sticky=tk.N)
tk.Frame(f, height=5).grid(row=7, column=1)

## diteur pour le source du programme
tk.Label(f, text='Source |').grid(row=3, column=7, columnspan=4, sticky=tk.E)
l_src = tk.Text(f, height=21, width=50, font=monospace)
l_src.grid(row=4, column=7, rowspan=2, columnspan=4, sticky=tk.N)
l_src.insert(tk.END, """3) i(ADD)      # include ADD
Z(12)
10) J(3,4,11)  # always next instruction
15) Z(7)       # R7 <- 0
16) S(2)       # R2 <- R2 + 1
17) S(2)       # R2 <- R2 + 1""")#???

f.grid(row=3, column=1)



#
f = None
#???w.bind('<Button>', cmd_change_reg)
w.mainloop()
##\endcond MAIN
