#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\file
# Application <b>Natural Tk</b> calculant quelques fonctions arithmtiques
#
# \htmlonly <a class="relative" href="naturalTk.png" target="_blank"><img
#   src="naturalTk_th.png" border="0" align="top" alt="[naturalTk_th.png]"></a>\endhtmlonly\n
# Cf. \htmlonly <a href="http://www.opimedia.be/naturels/" target="_blank">
#   <tt>http://www.opimedia.be/naturels/</tt></a>\endhtmlonly

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 26 fvrier 2009
# v.00.00 --- 14 juin 2009
#         --- 29 septembre 2009 : nouveau site web
#         --- 20 dcembre 2009 : adapte pour Python 3
# v.00.01 --- 16 mars 2010 : nouveau site web et changement des % en .format()
#         --- 12 avril 2010 : cfr. -> cf.
###############################################################################

## Version
VERSION = 'v.00.01 --- 2010 April 12'

import sys

if sys.version_info[0] >= 3:  # Python >= 3
    import tkinter as tk
    import tkinter.font as tkFont
    import tkinter.messagebox as tkMessageBox

    ## Remplacement de la fonction disparue dans Python 3
    def unichr(i):
        return chr(i)

else:                         # 2.6 <= Python < 3
    import Tkinter as tk
    import tkFont
    import tkMessageBox

import DSPython
import DSPython.factors as factors
import DSPython.nbsystem as nbsystem

try:
    if not 'profile' in dir():
        import psyco
        psyco.full()
except ImportError:
    pass



# ####################
# Variables globales #
######################
## Naturel courant
n = 0

## Primaries (liste des (facteur premier, exposant)) de n ou None
primaries = None



# ###################################
# Variables globales de l'interface #
#####################################
## Fentre principale
tk_Win = tk.Tk()

## Police de caractres  taille fixe
tk_Font_monospace = tkFont.Font(tk_Win, size=10, family='courier')



# ############################
# Fonctions pour l'interface #
##############################
## MessageBox About...
def cmd_about():
    tkMessageBox.showinfo('About...',
                          """Natural Tk

{0}
(c) Olivier Pirson --- DragonSoft
{1}


Infos:
{2}
Python {3}""".format(VERSION, DSPython.DS_web, DSPython.VERSION, sys.version))


## Initialise le naturel n avec la valeur saisie
def cmd_change_n(event=None):
    global n

    s = tk_Entry_n.get()
    try:
        n = int(s)
    except:
        n = -1

    if n < 0:
        n = 0

    cmd_update()


## Callback pour le Button 'Quit'
def cmd_quit():
    if tkMessageBox.askyesno('Quit?', 'Quit Natural Tk?'):
        tk_Win.quit()


## Mise  jour
def cmd_update():
    global primaries

    tk_Label_n_10.config(text='n = ' + str(n))
    tk_Label_n_2.config(text=bin(n))
    tk_Label_n_3.config(text='0t{0}'.format(nbsystem.to_str(n, b=3)))
    tk_Label_n_16.config(text=hex(n))

    primaries = (factors.primaries(n) if n > 0
                 else None)
    tk_Label_factors.config(text=(factors.primaries_str(primaries, times=' . ') if primaries != None
                                  else '/'))
    tk_Label_div_nb.config(text=unichr(957) + '(n) = '
                                + (str(factors.divisors_nb(primaries)) if primaries != None
                                   else unichr(8734)))
    tk_Label_div_sum.config(text=unichr(963) + '(n) = '
                                 + (str(factors.divisors_sum(primaries)) if primaries != None
                                    else unichr(8734)))

    tk_Label_mobius.config(text=unichr(956) + '(n) = '
                                + (str(factors.mobius(primaries)) if primaries != None
                                   else '/'))
    tk_Label_rad.config(text='rad(n) = '
                             + (str(factors.primaries_to_n(factors.rad(primaries)))
                                if primaries != None
                                else '/'))
    tk_Label_totient.config(text=unichr(966) + '(n) = '
                                 + (str(factors.totient(primaries)) if primaries != None
                                    else '1'))

    tk_Label_4sqr.config(text='GR(n) = '
                              + (str(factors.nb_in_integers_4sqr(primaries)) if primaries != None
                                 else '1'))



# ######\cond MAIN
# Main #
########
tk_Win.title('Natural Tk')
tk_Win.resizable(0,0)
tk_Win.protocol('WM_DELETE_WINDOW', cmd_quit)


## Frame temporaire utilis pour disposer les lments
tk_Frame = tk.Frame(tk_Win)

## Entry pour le naturel n
tk_Entry_n = tk.Entry(tk_Frame, width=20)
tk_Entry_n.insert(tk.END, '')
tk_Entry_n.bind('<Return>', cmd_change_n)
tk_Entry_n.pack(side=tk.LEFT)

tk.Frame(tk_Frame, width=10).pack(side=tk.LEFT)
tk.Button(tk_Frame, text='About', command=cmd_about).pack(side=tk.LEFT)
tk.Button(tk_Frame, text='Quit', command=cmd_quit).pack(side=tk.LEFT)

tk_Frame.pack(side=tk.TOP, fill=tk.X)


tk_Frame = tk.Frame(tk_Win)
## Label pour afficher n en base 10
tk_Label_n_10 = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_n_10.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher n en base 2
tk_Label_n_2 = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_n_2.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher n en base 3
tk_Label_n_3 = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_n_3.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher n en base 16
tk_Label_n_16 = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_n_16.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)


tk_Frame = tk.Frame(tk_Win, height=5)
tk_Frame.pack(side=tk.TOP)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher n dcompos en facteurs premiers
tk_Label_factors = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_factors.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher le nombre de diviseurs
tk_Label_div_nb = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_div_nb.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher la somme des diviseurs
tk_Label_div_sum = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_div_sum.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)


tk_Frame = tk.Frame(tk_Win)
## Label pour afficher la valeur de la fonction mu de Mobius
tk_Label_mobius = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_mobius.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher la valeur de la fonction radical
tk_Label_rad = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_rad.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher la valeur de la fonction totient
tk_Label_totient = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_totient.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher le nombre de dcomposition en somme de 4 carrs
tk_Label_4sqr = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_4sqr.pack(side=tk.RIGHT, fill=tk.X)
tk_Frame.pack(side=tk.TOP, fill=tk.X)


tk_Frame = None
cmd_update()
tk_Win.mainloop()
##\endcond MAIN
