#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\file
# Application <b>Combinator Tk</b> permettant de manipuler les combinateurs
#
# \htmlonly <a class="relative" href="combinatorTk.png" target="_blank"><img
#  src="combinatorTk_th.png" border="0" align="top" alt="[combinatorTk_th.png]"></a>\endhtmlonly\n
# Cf. \htmlonly <a href="http://www.opimedia.be/Bruno_Marchal/index.htm#Theo" target="_blank">
#   <tt>http://www.opimedia.be/Bruno_Marchal/index.htm#Theo</tt></a>\endhtmlonly\n
# et \htmlonly <a href="http://fr.wikipedia.org/wiki/Logique_combinatoire" target="_blank">
#   <tt>http://fr.wikipedia.org/wiki/Logique_combinatoire</tt></a>\endhtmlonly
# pour une prsentation de la logique combinatoire.

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 14 fvrier 2008
# v.00.00 --- 2 mars 2008
#         --- 19 mai 2008
# v.00.01 --- 14 novembre 2008
# v.00.02 --- 20 novembre 2008
# v.00.03 --- 22 novembre 2008
# v.00.04 --- 26 fvrier 2009
#         --- 29 septembre 2009 : nouveau site web
# v.00.05 --- 14 dcembre 2009 : from __future__ import division
# v.00.06 --- 20 dcembre 2009 : adapte pour Python 3
# v.00.07 --- 16 mars 2010 : nouveau site web et changement des % en .format()
#         --- 12 avril 2010 : cfr. -> cf.
###############################################################################
from __future__ import division

## Version
VERSION = 'v.00.07 --- 2010 April 12'

import string, sys, time

if sys.version_info[0] >= 3:  # Python >= 3
    import tkinter as tk
    import tkinter.font as tkFont
    import tkinter.messagebox as tkMessageBox

    ## Remplacement de la fonction disparue dans Python 3
    def unichr(i):
        return chr(i)

else:                         # 2.6 <= Python < 3
    import Tkinter as tk
    import tkFont
    import tkMessageBox

import DSPython
import DSPython.combinator as combinator

try:
    if not 'profile' in dir():
        import psyco
        psyco.full()
except ImportError:
    pass



# ####################
# Variables globales #
######################
## Combinateur courant (ou None si champ de saisie vide ou incorrect)
comb = None


## Nombre d'tapes values
nb_eval = 0

## Nombre d'tapes  valuer d'un coup
nb_eval_step = 1

## Naturel pour combinateur
numeral = 0

## Si True alors suspend l'valuation en cours
pause = False

## Si True alors une valuation est en cours
running = False

## Dure en ms de l'attente entre deux excutions (si tk_Var_sleep)
sleep_delay = 100



# ###################################
# Variables globales de l'interface #
#####################################
## Fentre principale
tk_Win = tk.Tk()

## Police de caractres  taille fixe
tk_Font_monospace = tkFont.Font(tk_Win, size=10, family='courier')

## Police de caractres  taille fixe
tk_Font_monospace8 = tkFont.Font(tk_Win, size=8, family='courier')


## Si True alors numeral est transform en naturel de Church
tk_Var_numeral_Church = tk.BooleanVar()


## Si True alors affiche toutes les parenthses dans les combinateurs
tk_Var_show_allparent = tk.BooleanVar()

## Si True alors affiche les espaces dans les combinateurs
tk_Var_show_space = tk.BooleanVar()


## Si True alors temporise entre chaque instruction excute
tk_Var_sleep = tk.BooleanVar()
tk_Var_sleep.set(True)



# ##########
# Fonction #
############
## Renvoie le combinateur c sous forme de string
def comb_to_str(c):
    """Renvoie le combinateur c sous forme de string

    Pre: c: None ou Combinator"""
    assert (c == None) or isinstance(c, combinator.Combinator), type(c)

    return (c.__str__(allparent=tk_Var_show_allparent.get(),
                      space=(' ' if tk_Var_show_space.get()
                             else '')) if c != None
            else '')



# ############################
# Fonctions pour l'interface #
##############################
## MessageBox About...
def cmd_about():
    tkMessageBox.showinfo('About...',
                          """Combinator Tk

{0}
(c) Olivier Pirson --- DragonSoft
{1}


Infos:
{2}
Python {3}""".format(VERSION, DSPython.DS_web, DSPython.VERSION, sys.version))


## Initialise sleep_delay avec la valeur saisie
def cmd_change_delay(event=None):
    global sleep_delay

    s = tk_Entry_delay.get()
    try:
        sleep_delay = int(s)
    except:
        sleep_delay = -1

    if sleep_delay < 0:
        sleep_delay = 0
        tk_Entry_delay.delete(0, tk.END)


## Initialise nb_eval_step avec la valeur saisie
def cmd_change_step(event=None):
    global nb_eval_step

    s = tk_Entry_step.get()
    try:
        nb_eval_step = int(s)
    except:
        nb_eval_step = -1

    if nb_eval_step <= 0:
        nb_eval_step = 0
        tk_Entry_step.delete(0, tk.END)
        if not tkMessageBox.askyesno('No step?',
                                     """Do you want no limitation in evaluation?
(Some combinators run for ever!)"""):
            nb_eval_step = 1
            tk_Entry_step.delete(0, tk.END)
            tk_Entry_step.insert(tk.END, str(nb_eval_step))


## Initialise numeral avec la valeur saisie
def cmd_change_numeral(event=None):
    global numeral

    s = tk_Entry_numeral.get()
    try:
        numeral = int(s)
    except:
        numeral = -1

    if numeral < 0:
        numeral = 0
        tk_Entry_numeral.delete(0, tk.END)

    cmd_insert_comb(combinator.Combinator.n_to_Church(numeral) if tk_Var_numeral_Church.get()
                    else combinator.Combinator.n_to_Barendregt(numeral))
    cmd_comb_update()


## Callback pour le Button 'Clear'
def cmd_clear(event=None):
    global comb, nb_eval

    cmd_stop()
    comb = None
    tk_Entry_comb.delete(0, tk.END)
    tk_Label_comb.config(text='')
    tk_Listbox_combeval.delete(0, tk.END)
    nb_eval = 0
    tk_Label_nb_eval.config(text=str(nb_eval))
    tk_Button_eval.config(state=tk.DISABLED)


## Mise  jour
def cmd_comb_update(event=None):
    global comb

    # Spare les caractres saisis dans tk_Entry_comb par des espaces
    #   et change les [] ou {} par des ()
    s = ' '.join([c
                  for c in tk_Entry_comb.get().translate(cmd_comb_update.TRANS)])

    # Tente de convertir s en Combinator
    try:
        comb = combinator.Combinator(s)
        tk_Label_comb.config(text=comb_to_str(comb))
    except:
        comb = None
        s = s[:-1]
        while (comb == None) and (s != ''):  # essaie avec les chanes de plus en plus courtes
            try:
                comb = combinator.Combinator(s)
            except:
                comb = None
            s = s[:-1]
        tk_Label_comb.config(text=comb_to_str(comb) + ' ..?')

    # Active ou dsactive le bouton d'valuation en fonction de la stabilit de comb
    tk_Button_eval.config(state=(tk.DISABLED if (comb == None) or comb.stable_is()
                                 else tk.NORMAL))

## Table de translation : [] ou {} --> ()
if sys.version_info[0] >= 3:  # Python >= 3
    cmd_comb_update.TRANS = str.maketrans('[]{}', '()()')
else:
    cmd_comb_update.TRANS = string.maketrans('[]{}', '()()')


## Callback pour le Button 'Eval'
def cmd_eval():
    global nb_eval, pause, running

    cmd_change_delay()
    cmd_change_step()
    if not running:
        tk_Button_eval.config(relief=tk.SUNKEN)
        tk_Button_stop.config(state=tk.NORMAL)
        tk_Listbox_combeval.delete(0, tk.END)
        nb_eval = 0
        if comb != None:
            ds = {}  # dictionnaire des combinateurs rencontrs au cours de l'valuation
            ds[comb.__str__(space='')] = 0
            c = comb
            running = True
            while running:
                while pause and running:
                    tk_Win.update()
                if running:
                    tk_Win.update()
                    if tk_Var_sleep.get():
                        time.sleep(sleep_delay/1000)

                    # C'est ici que le combinateur c est valu (pour nb_eval_step tapes)
                    c, nb_eval_last = c(nb=(nb_eval_step if nb_eval_step > 0
                                            else None))

                    nb_eval += nb_eval_last
                    tk_Label_nb_eval.config(text=str(nb_eval))
                    if nb_eval_last > 0:
                        tk_Listbox_combeval.insert(tk.END, comb_to_str(c))
                        s = c.__str__(space='')
                        if s in ds:  # ce combinateur c a dj t rencontr
                            # ??? ne fonctionne pas ?
                            tk_Listbox_combeval.insert(tk.END, '... {0}'.format(ds[s]))
                            running = False
                        else:        # nouveau combinateur c dans l'valuation de comb
                            ds[s] = nb_eval
                        tk_Listbox_combeval.see(tk.END)
                    else:
                        running = False
            pause = False
        tk_Button_eval.config(relief=tk.RAISED)
        tk_Button_stop.config(state=tk.DISABLED)
    else:
        pause = not pause
        tk_Button_eval.config(relief=(tk.RAISED if pause
                                      else tk.SUNKEN))


## Ajoute le combinateur c  la fin du champ de saisie tk_Entry_comb
def cmd_insert_comb(c):
    if c != None:
        s = str(c)
        if tk_Entry_comb.get() != '':
            s = (' {0}' if s.find(' ') < 0
                 else ' [{0}]').format(s)
        tk_Entry_comb.insert(tk.INSERT, s)
        cmd_comb_update()


## Callback pour le Button 'Quit'
def cmd_quit():
    if tkMessageBox.askyesno('Quit?', 'Quit Combinator Tk?'):
        cmd_stop()
        tk_Win.quit()


## Callback pour le Button 'Stop'
def cmd_stop():
    global running

    if running:
        running = False


## Copie le combinateur courant dans la "mta-variable" x
def cmd_to_var_x():
    combinator.var_x = comb
    tk_Label_var_x.config(text=('' if comb == None
                                else str(comb.__str__(space=''))))

    # Active ou dsactive le bouton d'valuation en fonction de la stabilit de comb
    tk_Button_eval.config(state=(tk.DISABLED if (comb == None) or comb.stable_is()
                                 else tk.NORMAL))


## Copie le combinateur courant dans la "mta-variable" y
def cmd_to_var_y():
    combinator.var_y = comb
    tk_Label_var_y.config(text=('' if comb == None
                                else str(comb)))

    # Active ou dsactive le bouton d'valuation en fonction de la stabilit de comb
    tk_Button_eval.config(state=(tk.DISABLED if (comb == None) or comb.stable_is()
                                 else tk.NORMAL))


## Copie le combinateur courant dans la "mta-variable" z
def cmd_to_var_z():
    combinator.var_z = comb
    tk_Label_var_z.config(text=('' if comb == None
                                else str(comb)))

    # Active ou dsactive le bouton d'valuation en fonction de la stabilit de comb
    tk_Button_eval.config(state=(tk.DISABLED if (comb == None) or comb.stable_is()
                                 else tk.NORMAL))



# ######\cond MAIN
# Main #
########
tk_Win.title('Combinator Tk')
tk_Win.resizable(0,0)
tk_Win.protocol('WM_DELETE_WINDOW', cmd_quit)


## Frame temporaire utilis pour disposer les lments
tk_Frame = tk.Frame(tk_Win)

for c in ('B', 'C', 'I', 'K', 'KI', 'L', 'M', 'O', 'R', 'S', 'T', 'U', 'V', 'W', 'Y'):
    exec('tk.Button(tk_Frame,'
         + ' text="{0}", command=lambda : cmd_insert_comb(combinator.{1})).pack(side=tk.LEFT)'
         .format(c, c))

tk.Frame(tk_Frame, width=5).pack(side=tk.LEFT)

for c in ((unichr(953), 'iota'),
          (unichr(937), 'Omega')):
    exec('tk.Button(tk_Frame,'
         + ' text="{0}", command=lambda : cmd_insert_comb(combinator.{1})).pack(side=tk.LEFT)'
         .format(*c))

tk.Frame(tk_Frame, width=10).pack(side=tk.LEFT)

for c in ('not', 'and', 'or', 'imp'):
    exec('tk.Button(tk_Frame,'
         + ' text="{0}", command=lambda : cmd_insert_comb(combinator.B{1})).pack(side=tk.LEFT)'
         .format(c, c))

tk.Frame(tk_Frame, width=10).pack(side=tk.LEFT)

## Entry pour le nombre
tk_Entry_numeral = tk.Entry(tk_Frame, width=5)
tk_Entry_numeral.insert(tk.END, str(numeral))
tk_Entry_numeral.bind('<Return>', cmd_change_numeral)
tk_Entry_numeral.pack(side=tk.LEFT)

tk.Checkbutton(tk_Frame, text='Church', variable=tk_Var_numeral_Church,
               command=cmd_change_numeral).pack(side=tk.LEFT)

tk.Frame(tk_Frame, width=5).pack(side=tk.LEFT)

for c in ('x', 'y', 'z'):
    exec('tk.Button(tk_Frame,'
         + ' text="{0}", command=lambda : cmd_insert_comb(combinator.V{1})).pack(side=tk.LEFT)'
         .format(c, c))

    exec('tk.Button(tk_Frame, text=unichr(8593), command=cmd_to_var_{0}).pack(side=tk.LEFT)'
         .format(c))
    exec('tk.Button(tk_Frame, text=unichr(8595),'
         + ' command=lambda : cmd_insert_comb(combinator.var_{0})).pack(side=tk.LEFT)'
         .format(c))

    exec('tk_Label_var_{0} = tk.Label(tk_Frame, font=tk_Font_monospace8, width=5)'.format(c))
    exec('tk_Label_var_{0}.pack(side=tk.LEFT)'.format(c))

    tk.Frame(tk_Frame, width=5).pack(side=tk.LEFT)

tk.Frame(tk_Frame, width=10).pack(side=tk.LEFT)

## Bouton 'Eval'
tk_Button_eval = tk.Button(tk_Frame, text='Eval', command=cmd_eval, state=tk.DISABLED)
tk_Button_eval.pack(side=tk.LEFT)

## Bouton 'Stop'
tk_Button_stop = tk.Button(tk_Frame, text='Stop', command=cmd_stop, foreground='red',
                                state=tk.DISABLED)
tk_Button_stop.pack(side=tk.LEFT)

tk.Frame(tk_Frame, width=10).pack(side=tk.LEFT)
tk.Button(tk_Frame, text='Clear', command=cmd_clear).pack(side=tk.LEFT)

tk.Frame(tk_Frame, width=10).pack(side=tk.LEFT)
tk.Button(tk_Frame, text='About', command=cmd_about).pack(side=tk.LEFT)
tk.Button(tk_Frame, text='Quit', command=cmd_quit).pack(side=tk.LEFT)

tk_Frame.pack(side=tk.TOP, fill=tk.X)


#

## Entry pour le combinateur
tk_Entry_comb = tk.Entry(tk_Win, width=100, font=tk_Font_monospace)
tk_Entry_comb.bind('<Return>', cmd_comb_update)
tk_Entry_comb.pack(side=tk.TOP, fill=tk.X)

tk_Frame = tk.Frame(tk_Win)
## Label pour afficher le combinateur
tk_Label_comb = tk.Label(tk_Frame, font=tk_Font_monospace)
tk_Label_comb.pack(side=tk.LEFT, fill=tk.X)

tk_Frame.pack(side=tk.TOP, fill=tk.X)


tk_Frame = tk.Frame(tk_Win)
## Listbox pour afficher l'valuation du combinateur
tk_Listbox_combeval = tk.Listbox(tk_Frame, width=120, height=20, font=tk_Font_monospace)
tk_Listbox_combeval.grid(sticky=tk.N + tk.S)

## Scrollbar
tk_Scrollbar = tk.Scrollbar(tk_Frame)
tk_Listbox_combeval.config(yscrollcommand=tk_Scrollbar.set)
tk_Scrollbar.config(command=tk_Listbox_combeval.yview)
tk_Scrollbar.grid(row=0, column=1, sticky=tk.N + tk.S)

tk_Scrollbar = tk.Scrollbar(tk_Frame, orient=tk.HORIZONTAL)
tk_Listbox_combeval.config(xscrollcommand=tk_Scrollbar.set)
tk_Scrollbar.config(command=tk_Listbox_combeval.xview)
tk_Scrollbar.grid(row=1, sticky=tk.E + tk.W)

tk_Frame.pack(side=tk.TOP, fill=tk.X)


#
tk_Frame = tk.Frame(tk_Win)

## Checkbutton
tk.Checkbutton(tk_Frame, text='All parenthesis  ', variable=tk_Var_show_allparent,
               command=cmd_comb_update).pack(side=tk.LEFT)
tk.Checkbutton(tk_Frame, text='Space  ', variable=tk_Var_show_space,
               command=cmd_comb_update).pack(side=tk.LEFT)

tk.Checkbutton(tk_Frame, text='Delay:', variable=tk_Var_sleep,
               command=cmd_change_delay).pack(side=tk.LEFT)
## Entry pour le dlai
tk_Entry_delay = tk.Entry(tk_Frame, width=5)
tk_Entry_delay.insert(tk.END, str(sleep_delay))
tk_Entry_delay.bind('<Return>', cmd_change_delay)
tk_Entry_delay.pack(side=tk.LEFT)
tk.Label(tk_Frame, text='ms').pack(side=tk.LEFT)

tk.Label(tk_Frame, text='   Step:').pack(side=tk.LEFT)
## Entry pour la valeur de nb_eval_step
tk_Entry_step = tk.Entry(tk_Frame, width=5)
tk_Entry_step.insert(tk.END, str(nb_eval_step))
tk_Entry_step.bind('<Return>', cmd_change_step)
tk_Entry_step.pack(side=tk.LEFT)

tk.Label(tk_Frame, text='   Nb triggers: ').pack(side=tk.LEFT)
## Label pour afficher le nombre d'tapes values
tk_Label_nb_eval = tk.Label(tk_Frame, text='0')
tk_Label_nb_eval.pack(side=tk.LEFT)

tk_Frame.pack(side=tk.TOP, fill=tk.X)



#
tk_Frame = None
tk_Win.bind('<Escape>', cmd_clear)
tk_Win.mainloop()
##\endcond MAIN
