#!/usr/bin/env python
# -*- coding: latin-1 -*-

# Test du paquetage DSPython

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 1er juillet 2007
####################################
from __future__ import print_function

# Date du dernier changement pour ce programme
VERSION = 'DSPython_test_all --- 2010 March 16'

import subprocess, sys, time



#############
# Variables #
#############
# Liste des modules  tester
modules = ['__init__.py',
           'debug.py',

           'bool.py',

           'bit32.py',
           'nat32.py',

           'cnat32array.py',
           'cnat32table.py',

           'natural.py',
           'natseq.py',
           'factors.py',

           'integer.py',
           'intmod.py',

           'nbsystem.py',
           'baset.py',
           'bintree.py',

           'partitions.py',

           'tnp1.py',

           'numbernone.py',
           'finitec.py',

           'polynomial.py',

           'combinator.py',
           'knots.py',
           'urmCutland.py']

# Indices du premier module  tester
m_from = 0

# Indices du dernier module  tester
m_to = len(modules) - 1


# Liste des modules avec erreur
modules_error = []


# Temps total
t_total = 0.0


# Interprteur Python utilis avec ses paramtres
PYTHON = sys.executable
if sys.version_info[0] < 3:
    PYTHON += ' -tt'  # vrifie les indendations


# Paramtre qui sera transmi : ' --quick' ou '' ou ' --fat'
speed = ''



#############
# Fonctions #
#############
def help_msg():
    """Affiche le message d'aide sur la sortie des erreurs
    et termine le programme par un code d'erreur 1"""
    print("""DSPython_test_all [-3] [--error] [--quick|--fat] [from [to]]

  DSPython test
  (c) Olivier Pirson --- DragonSoft --- http://www.opimedia.be/DS/
             {0}
  Options: -3: '-Qnew -Qwarn -3' if Python < 3
           --error: warnings become errors
           --quick, --fat: speed parameter to each module
           from: first module index to be testing [0]
           to:   last module index to be testing [last]""".format(VERSION),
          file=sys.stderr)
    exit(1)


def seconds_to_str(x):
    """Renvoie le nombre de secondes n sous forme de string
    pre: x: float
    result: String"""
    m, s = divmod(x, 60)
    m = int(m)
    s = int(s)
    r = ''
    if m > 0:
        r += str(m) + "'"
    if (s > 0) or (r == ''):
        r += str(s) + '"'
    return '~ ' + r



########
# Main #
########
if __name__ != '__main__':
    print('!This is a program, not a module!', file=sys.stderr)
    exit(1)

if not __debug__:
    print("!Option '-O' must be disabled, because 'assert' is necessary!", file=sys.stderr)
    exit(1)


# Version de Python utilise
print("""Python {0}
\ton platform '{1}' {2} endian
""".format(sys.version, sys.platform, sys.byteorder))


# Lecture des paramtres
i = 0
for s in sys.argv[1:]:
    if s == '-3':
        if sys.version_info[0] < 3:
            PYTHON += ' -Qnew -Qwarn -3'  # warnings pour prparer le passage  Python 3
    elif s == '--error':
        PYTHON += ' -Werror'
    elif (s == '--quick') or (s == '--fat'):
        speed = ' '+ s
    else:
        try:
            n = min(max(0, int(s)), len(modules) - 1)
            if i == 0:
                m_from = n
            elif i == 1:
                m_to = n
            else:
                help_msg()
            i += 1
        except:
            help_msg()


# Affiche l'interprteur Python utilis avec ses paramtres
print(PYTHON)


# Affiche la liste des modules
print()
for i in range(0, len(modules)):
    print('{0:2}'.format(i), ('-' if m_from <= i <= m_to
                              else 'x'), modules[i])


# Teste les modules slectionns un par un
for m in modules[m_from:m_to + 1]:
    print()
    sys.stdout.flush()

    com = PYTHON + ' DSPython/' + m + speed
    try:
        t = time.clock()
        ret = subprocess.call(com, shell=True)
        t = time.clock() - t
        t_total += t
        print('---', seconds_to_str(t))
        sys.stdout.flush()
        if ret != 0:
            print('!***', com, file=sys.stderr)
            print("!\ttest of '{0}' was terminated by signal {1}".format(m, ret), file=sys.stderr)
            sys.stderr.flush()
            modules_error.append(m)
    except OSError as e:
        print("!Execution of '{0}' failed:".format(com), e, file=sys.stderr)
        sys.stderr.flush()
        modules_error.append(m)

print('\n*** ended', seconds_to_str(t_total))



# Liste des modules ayant rencontr une erreur
if modules_error == []:
    print('None error founded')
else:
    print('Module(s) with error:')
    for m in modules_error:
        print(' ', m)
