#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.numbernone Nombre non ncessairement dfini
# !!! Work in progress !!!
# ???  transformer en class NumberNone

##\file
# Nombre non ncessairement dfini
# !!! Work in progress !!!

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 4 fvrier 2006
####################################
from __future__ import division
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'numbernone --- 2010 March 16'

import numbers



# ###########
# Fonctions #
#############
## x + y
def add(x, y):
    """Renvoie x + y
      ou None si x ou y == None

    Pre: x: Number ou None
         y: Number ou None

    Result: Number ou None

    O(x, y) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(y, numbers.Number) or (y == None), y

    return (x + y if (x != None) and (y != None)
            else None)


## x / y
def div(x, y):
    """Renvoie x / y
      ou None si x ou y == None ou y == 0

    Pre: x: Number ou None
         y: Number ou None

    Result: Number ou None

    O(x, y) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(y, numbers.Number) or (y == None), y

    return (x / y if (x != None) and (y != None) and (y != 0)
            else None)


## divmod(x, y)
def divmod(x, y):
    """Renvoie divmod(x, y)
      ou None si x ou y == None ou y == 0

    Pre: x: Real ou None
         y: Real ou None

    Result: (Real ou None, Real ou None)

    O(x, y) = ..."""
    assert isinstance(x, numbers.Real) or (x == None), x
    assert isinstance(y, numbers.Real) or (y == None), y

    return (x.__divmod__(y) if (x != None) and (y != None) and (y != 0)
            else (None, None))


## k<sup>e</sup> puissance factorielle descendante de x
def falling_factorial_pow(x, k):
    """Renvoie la kme puissance factorielle descendante de x
      == x * (x - 1) * (x - 2) * ... * (x - k + 1)
      ou None si non dfini

    Pre: x: Number ou None
         k: Integral ou None

    Result: Number ou None

    O(x, k) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(k, numbers.Integral) or (k == None), k

    if (x != None) and (k != None):
        if k >= 0:
            r = 1
            for i in range(k):
                r *= x
                x -= 1
                if r == 0:
                    return 0
            return r
        else:
            return inv(rising_factorial_pow(x + 1, -k))
    else:
        return None


## 1/x
def inv(x):
    """Renvoie 1/x
      ou None si x == None ou 0

    Pre: x: Number ou None

    Result: Number ou None

    O(x) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x

    return (1/x if (x != None) and (x != 0)
            else None)


## x mod y
def mod(x, y):
    """Renvoie x mod y
      ou None si x ou y == None ou y == 0

    Pre: x: Number ou None
         y: Number ou None

    Result: Number ou None

    O(x, y) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(y, numbers.Number) or (y == None), y

    return (mod(x, y) if (x != None) and (y != None) and (y != 0)
            else None)


## x * y
def mul(x, y):
    """Renvoie x * y
      ou None si x ou y == None

    Pre: x: Number ou None
         y: Number ou None

    Result: Number ou None

    O(x, y) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(y, numbers.Number) or (y == None), y

    return (x*y if (x != None) and (y != None)
            else None)


## -x
def neg(x):
    """Renvoie -x
      ou None si x == None

    Pre: x: Number ou None

    Result: Number ou None

    O(x) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x

    return (-x if x != None
            else None)


## k<sup>e</sup> puissance factorielle montante de x
def rising_factorial_pow(x, k):
    """Renvoie la kme puissance factorielle montante de x
      == x * (x + 1) * (x + 2) * ... * (x + k - 1)
      ou None si non dfini

    Pre: x: Number ou None
         k: Integral ou None

    Result: Number ou None

    O(x, k) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(k, numbers.Integral) or (k == None), k

    if (x != None) and (k != None):
        if k >= 0:
            r = 1
            for i in range(k):
                r *= x
                x += 1
                if r == 0:
                    return 0
            return r
        else:
            return inv(falling_factorial_pow(x + 1, -k))
    else:
        return None


## x - y
def sub(x, y):
    """Renvoie x - y
      ou None si x ou y == None

    Pre: x: Number ou None
         y: Number ou None

    Result: Number ou None

    O(x, y) = ..."""
    assert isinstance(x, numbers.Number) or (x == None), x
    assert isinstance(y, numbers.Number) or (y == None), y

    return (x - y if (x != None) and (y != None)
            else None)



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        import sys

        import math

        import DSPython.debug as debug
        import DSPython.bit32 as bit32

        debug.test_begin(VERSION, __debug__)

        print('add()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('div()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('divmod()...', end=''); sys.stdout.flush()
        assert divmod(4, 0) == (None, None), divmod(4, 0)
        assert divmod(7, 3) == (2, 1), divmod(7, 3)
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('falling_factorial_pow()...', end=''); sys.stdout.flush()
        assert falling_factorial_pow(0, 0) == 1, falling_factorial_pow(0, 0)
        for n in range(1000):
            assert falling_factorial_pow(n, 0) == 1,         (n, falling_factorial_pow(n, 0))
            assert falling_factorial_pow(n, 1) == n,         (n, falling_factorial_pow(n, 1))
            assert falling_factorial_pow(n, 2) == n*(n - 1), (n, falling_factorial_pow(n, 2))
            assert falling_factorial_pow(n, 3) == n*(n - 1)*(n - 2), \
                   (n, falling_factorial_pow(n, 3))
            assert falling_factorial_pow(n, n + 1) == 0,     (n, falling_factorial_pow(n, n+1))
        for k in range(20):
            assert falling_factorial_pow(k, k) == math.factorial(k), \
                   (k, math.factorial(k), falling_factorial_pow(k, k))
        for k in range(20):
            assert falling_factorial_pow(k + 1, k) == math.factorial(k + 1), \
                   (k, math.factorial(k + 1), falling_factorial_pow(2, k))
        for k in range(1, 100):
            assert falling_factorial_pow(0, k) == 0, (k, falling_factorial_pow(0, k))
        for k in range(1, 20):
            for n in range(k, min(100, int(pow(bit32.MERSENNE32, 1/k)) + 3)):
                assert falling_factorial_pow(n, k) \
                       == math.factorial(n)//math.factorial(n - k), \
                       (n, k, math.factorial(n + k - 1)//math.factorial(n - 1),
                        falling_factorial_pow(n, k))
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('inv()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('mod()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('mul()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('neg()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('rising_factorial_pow()...', end=''); sys.stdout.flush()
        assert rising_factorial_pow(0, 0) == 1, rising_factorial_pow(0, 0)
        for n in range(2000):
            assert rising_factorial_pow(n, 0) == 1,                 (n, rising_factorial_pow(n, 0))
            assert rising_factorial_pow(n, 1) == n,                 (n, rising_factorial_pow(n, 1))
            assert rising_factorial_pow(n, 2) == n*(n + 1),         (n, rising_factorial_pow(n, 2))
            assert rising_factorial_pow(n, 3) == n*(n + 1)*(n + 2), (n, rising_factorial_pow(n, 3))
        for k in range(20):
            assert rising_factorial_pow(1, k) == math.factorial(k), \
                   (k, math.factorial(k), rising_factorial_pow(1, k))
        for k in range(20):
            assert rising_factorial_pow(2, k) == math.factorial(k + 1), \
                   (k, math.factorial(k+1), rising_factorial_pow(2, k))
        for k in range(1, 20):
            assert rising_factorial_pow(0, k) == 0, (k, rising_factorial_pow(0, k))
            for n in range(1, min(100, int(pow(bit32.MERSENNE32, 1/k) - k + 4))):
                assert rising_factorial_pow(n, k) \
                       == math.factorial(n + k - 1)//math.factorial(n - 1), \
                       (n, math.factorial(n + k - 1)//math.factorial(n - 1),
                        rising_factorial_pow(n, k))
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('sub()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
