#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.natseq Squences de naturels

##\file
# Squences de naturels

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 28 dcembre 2006
####################################
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'natseq --- 2010 March 16'



# ###########
# Fonctions #
#############
# Produit des lments
def prod(s):
    """Renvoie le produit des lments de s
    (Si s est vide alors renvoie 1)

    Pre: s: squence de naturels

    Result: naturel

    O(n) = ..."""
    r = 1
    for n in s:
        r *= n
    return r


# Somme des lments
def sum(s):
    """Renvoie la somme des lments de s
      == sum_pow(s, 1)
    (Si s est vide alors renvoie 0)

    Pre: s: squence de naturels

    Result: naturel

    O(n) = ..."""
    r = 0
    for n in s:
        r += n
    return r


# Somme des lments de s ** k
def sum_pow(s, k):
    """Renvoie la somme des lments de s ** k
    (Si s est vide alors renvoie 0)
    (Si k == 0 alors renvoie len(s))

    Pre: s: squence de naturels

    Result: naturel

    O(n) = ..."""
    r = 0
    for n in s:
        r += n ** k
    return r


# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        import math, sys

        import DSPython.debug as debug

        debug.test_begin(VERSION, __debug__)

        print('prod()...', end=''); sys.stdout.flush()
        assert prod([]) == 1,        prod([])
        assert prod([0]) == 0,       prod([0])
        assert prod([1]) == 1,       prod([1])
        assert prod([1, 2]) == 2,    prod([1, 2])
        assert prod([2, 3]) == 6,    prod([2, 3])
        assert prod([1, 2, 0]) == 0, prod([1, 2, 0])
        for n in range(100):
            assert prod(range(1, n + 1)) == math.factorial(n), \
                   (n, prod(range(1, n + 1)), math.factorial(n), range(1, n + 1))
        print('ok'); sys.stdout.flush()


        print('sum()...', end=''); sys.stdout.flush()
        assert sum([]) == 0,        sum([])
        assert sum([0]) == 0,       sum([0])
        assert sum([1]) == 1,       sum([1])
        assert sum([1, 2]) == 3,    sum([1, 2])
        assert sum([1, 2, 0]) == 3, sum([1, 2, 0])
        for n in range(1000):
            assert sum(range(n + 1)) == n*(n + 1)//2, \
                   (n, sum(range(n + 1)), n*(n + 1)//2, range(n + 1))
        print('ok'); sys.stdout.flush()


        print('sum_pow()...', end=''); sys.stdout.flush()
        assert sum_pow([], 0) == 0,        sum_pow([], 0)
        assert sum_pow([0], 0) == 1,       sum_pow([0], 0)
        assert sum_pow([1], 0) == 1,       sum_pow([1], 0)
        assert sum_pow([1, 2], 0) == 2,    sum_pow([1, 2], 0)
        assert sum_pow([1, 2, 0], 0) == 3, sum_pow([1, 2, 0], 0)

        assert sum_pow([], 1) == 0,        sum_pow([], 1)
        assert sum_pow([0], 1) == 0,       sum_pow([0], 1)
        assert sum_pow([1], 1) == 1,       sum_pow([1], 1)
        assert sum_pow([1, 2], 1) == 3,    sum_pow([1, 2], 1)
        assert sum_pow([1, 2, 0], 1) == 3, sum_pow([1, 2, 0], 1)

        assert sum_pow([], 2) == 0,        sum_pow([], 2)
        assert sum_pow([0], 2) == 0,       sum_pow([0], 2)
        assert sum_pow([1], 2) == 1,       sum_pow([1], 2)
        assert sum_pow([1, 2], 2) == 5,    sum_pow([1, 2], 2)
        assert sum_pow([1, 2, 0], 2) == 5, sum_pow([1, 2, 0], 2)

        for n in range(1000):
            assert sum_pow(range(n + 1), 0) == n + 1, \
                   (n, sum_pow(range(n + 1), 0), range(n + 1))
            assert sum_pow(range(n + 1), 1) == n*(n + 1)//2, \
                   (n, sum_pow(range(n + 1), 1), n*(n + 1)//2, range(n + 1))
            assert sum_pow(range(n + 1), 2) == n*(n + 1)*(n*2 + 1)//6, \
                   (n, sum_pow(range(n + 1), 2), n*(n + 1)*(n*2 + 1)//6, range(n + 1))
            assert sum_pow(range(n + 1), 3) == (n*(n + 1)//2)**2, \
                   (n, sum_pow(range(n + 1), 3), (n*(n + 1)//2)**2, range(n + 1))
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
