#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.debug Dboggage

##\file
# Dboggage

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 22 aot 2006
####################################
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'debug --- 2010 March 16'

import collections, inspect, sys



# ############
# Constantes #
##############
## Niveau des assertions : ne faire que ce qui est le plus rapide
ASSERT_QUICK = -1

## Niveau des assertions : normal
ASSERT_NORMAL = 0

## Niveau des assertions : faire aussi ce qui est plus lent
ASSERT_FAT = 1



# ##########
# Variable #
############
## Niveau (plus ou moins lourd) des assertions  vrifier
assertspeed = ASSERT_NORMAL



# ###########
# Fonctions #
#############
## Renvoie assertspeed sous forme d'un string
def assertspeed_str():
    """Renvoie assertspeed sous forme d'un string

    O() = 1"""
    return ('ASSERT_QUICK', 'ASSERT_NORMAL', 'ASSERT_FAT')[assertspeed - ASSERT_QUICK]


## Renvoie un tuple des types de collections ABC support par item
def collections_tuple(item):
    """Renvoie un tuple des types de collections ABC supportes par item

    Result: tuple de string

    O() = ..."""
    s = []
    for t in ('Container', 'Hashable', 'Iterable', 'Iterator', 'Sized', 'Callable',
              'Sequence', 'MutableSequence', 'Set', 'MutableSet', 'Mapping', 'MutableMapping',
              'MappingView', 'KeysView', 'ItemsView', 'ValuesView'):
        if inspect.isclass(item):
            if issubclass(item, eval('collections.' + t)):
                s.append(t)
        else:
            if isinstance(item, eval('collections.' + t)):
                s.append(t)
    return tuple(s)


## Envoie sur la sortie des standards le message de dbut de test
def test_begin(version, debug, header='', args=sys.argv[1:]):
    """Envoie sur la sortie des standards le message de dbut de test

    Pre: version: string
         debug == True
         header: string
         args: liste de string"""
    global assertspeed

    ASSERT_OPTS = {'--quick':  ASSERT_QUICK,
                   '--normal': ASSERT_NORMAL,
                   '--fat':    ASSERT_FAT}

    print('*** {0}{1} --- __debug__ == {2}'.format(header, version, debug))
    sys.stdout.flush()
    for arg in args:
        try:
            assertspeed = ASSERT_OPTS[arg]
        except KeyError:
            pass
    print("*** args: '{0}'".format("' '".join(args)) if args
          else '*** args:', end=' ')
    print('--- assertspeed == ASSERT_{0}'
          .format(dict(zip(ASSERT_OPTS.values(), ASSERT_OPTS.keys()))[assertspeed][2:].upper()))
    sys.stdout.flush()

    assert debug


## Envoie sur la sortie des standards le message de fin de test
def test_end():
    """Envoie sur la sortie des standards le message de fin de test"""
    print('--- ok ---')
    sys.stdout.flush()



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        test_begin(VERSION, __debug__)

        print('assertspeed_str() ==', end=' '); sys.stdout.flush()
        print(assertspeed_str(), end=' ')
        print('ok'); sys.stdout.flush()
        test_end()

    main_test()
##\endcond MAINTEST
