#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.cnat32table
# Tableau compact de naturels stocks sur n_1, n_2,
# \htmlonly&hellip;\endhtmlonly, n_k \htmlonly &le;\endhtmlonly 32 bits
# !!! Work in progress !!!

##\file
# Tableau compact de naturels stocks sur n_1, n_2,
# \htmlonly&hellip;\endhtmlonly, n_k \htmlonly &le;\endhtmlonly 32 bits
# !!! Work in progress !!!

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 20 juillet 2006
####################################
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'cnat32table --- 2010 March 16'

import types

import DSPython.cnat32array as cnat32array



# ########
# Classe #
##########
## Tableau compact de naturels stock sur n<sub>1</sub>, n<sub>2</sub>, ..., n<sub>k</sub> bits
class Cnat32table:
    """Tableau compact de naturels stock sur n_1, n_2, ..., n_k bits
    (squence de Cnat32array)

    Pre: n_1, n_2, ..., n_k: 1 <= naturels <= 32"""

    ## Constucteur
    def __init__(self, sizes, items=None):
        """Renvoie un tableau compact de naturels
        sur sizes[0], sizes[1], ... sizes[k] bits.
        Si items == None alors renvoie un tableau vide

        Pre: sizes: squence de 1 <= naturels <= 32
             items: None

        O() = ..."""

        ## Nombre d'lments contenu dans le tableau
        self.len = 0

        ## Squence de Cnat32array
        self.l = [cnat32array.Cnat32array(s) for s in sizes]
        if items != None:
            raise NotImplementedError


    ## Nombre d'lments
    def __len__(self):
        """Renvoie le nombre d'lments du tableau

        Result: naturel

        O() = 1"""
        return self.len


    ## Transforme en string
    def __repr__(self):
        """Si le tableau est vide alors renvoie 'Cnat32table()'
          sinon renvoie 'Cnat32table(size, Cnat32array...)'

        Result: string quote

        O() = ..."""
        return ('Cnat32table()' if self.len == 0
                else 'Cnat32table({0}, {1!r})'.format(self.size, [n for n in self.l]))



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        import sys

        import DSPython.debug as debug

        debug.test_begin(VERSION, __debug__)

        print('Cnat32table()...', end=''); sys.stdout.flush()
        for k in range(1, 33):
            t = Cnat32table(())
            assert t.len == 0 == len(t) == 0, (t.len, len(t))
            assert isinstance(t.l, list), type(t.l)
            assert len(t.l) == 0, len(t.l)
            assert repr(t) == 'Cnat32table()'

            t = Cnat32table((k,))
            assert t.len == 0 == len(t) == 0, (t.len, len(t))
            assert isinstance(t.l, list), type(t.l)
            assert len(t.l) == 1, len(t.l)
            assert len(t.l[0]) == 0, len(t.l[0])
            assert repr(t) == 'Cnat32table()'
        print('???', end='')
        print('ok'); sys.stdout.flush()

        print('Cnat32table.__getitem__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Cnat32table.__len__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Cnat32table.__repr__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Cnat32table.__setitem__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
