#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.cnat32array
# Tableau compact de naturels stocks sur n \htmlonly &le;\endhtmlonly 32 bits
# !!! Work in progress !!!

##\file
# Tableau compact de naturels stocks sur n \htmlonly &le;\endhtmlonly 32 bits
# !!! Work in progress !!!

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 20 juillet 2006
####################################
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'cnat32array --- 2010 March 16'

import array

import DSPython
import DSPython.nat32 as nat32



# ########
# Classe #
##########
## Tableau compact de naturels stocks sur n bits.
class Cnat32array:
    """Tableau compact de naturels stocks sur n bits.
    Les lments sont stocks de faon contigu en mmoire.
    Par ex.: les lments d'un tableau de 5 lments sur 7 bits
             occupe 35 bits arrondi  2*32 == 64 bits

    Pre: n: 1 <= naturel <= 32"""

    ## Constucteur
    def __init__(self, size, items=None):
        """Renvoie un tableau compact de naturels stocks sur size bits.
        Si items == None alors renvoie un tableau vide

        Pre: size: 1 <= naturel <= 32
             items: None

        O() = ..."""
        assert DSPython.natural_is(size), size
        assert 1 <= size <= 32, size

        ## Taille maximale des lments (en binaire) du tableau
        self.size = size

        ## Nombre d'lments contenu dans le tableau
        self.len = 0

        ## Array d'lments de 32 bits contenant les lments du tableau
        self.a = array.array('L')
        if items != None:
            raise NotImplementedError


    ## self[key]
    def __getitem__(self, key):
        """Renvoie l'lment d'indice key
        ou un tuple contenant les lments de la tranche key.
        Lve une exception IndexError si le ou les indices n'existent pas

        Pre: key: entier ou tranche

        Result: naturel < 2**32 ou tuple de naturels < 2**32

        O() = ..."""
        assert DSPython.natural_is(key) or type(key) == types.SliceType, type(key)

        if type(key) != types.SliceType:  # indice simple
            if self.size == 32:  # chaque lment correspond exactement  1 lment du array
                return int(self.tables[key])
            else:                # chaque lment est plus petit qu'1 lment du array
                if key < 0:
                    key += self.len
                    if key < 0:
                        raise IndexError
                elif key >= self.len:
                    raise IndexError

                key, shift = divmod(key * self.size, 32)
                if self.size + shift <= 32: # l'lment tient sur 1 seul lment du array
                    return int((self.a[key] >> shift) & nat32.MERSENNE32_TUPLE[self.size])
                else:                       # l'lment est partag sur 2 lments du array
                    return int(((long(self.a[key+1]) << (32 - shift))
                                | (self.a[key] >> shift))
                               & nat32.MERSENNE32_TUPLE[self.size])
        else:                             # tranche d'indices
            return (tuple(self[i] for i in range(key.start, key.stop)) if key.step == None
                    else tuple(self[i] for i in range(key.start, key.stop, key.step)))


    ## Nombre d'lments
    def __len__(self):
        """Renvoie le nombre d'lments du tableau

        Result: naturel

        O() = 1"""
        return self.len


    ## Transforme en string
    def __repr__(self):
        """Si le tableau est vide alors renvoie 'Cnat32array()'
          sinon renvoie 'Cnat32array(size, [lments])'

        Result: string quote

        O() = ..."""
        return ('Cnat32array()' if self.len == 0
                else 'Cnat32array({0}, {1!r})'.format(self.size, [n for n in self.a]))


    ## self[key] = value
    def __setitem__(self, key, value):
        """Modifie le ou les lments d'indice key par value.
        Lve une exception IndexError si le ou les indices n'existent pas

        Pre: key: entier ou tranche

        O() = ..."""
        if self.size == 32:  # chaque lment correspond exactement  1 lment du array
            assert DSPython.natural_is(key) or type(key) == types.SliceType, type(key)

            self.a[key] = value
        else:                # chaque lment est plus petit qu'1 lment du array
            raise NotImplementedError



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        import sys

        import DSPython.debug as debug

        debug.test_begin(VERSION, __debug__)

        print('Cnat32array()...', end=''); sys.stdout.flush()
        for k in range(1, 33):
            t = Cnat32array(k)
            assert t.len == 0 == len(t) == 0, (t.len, len(t))
            assert t.size == k, t.size
            assert type(t.a) == array.array, type(t.a)
            assert len(t.a) == 0, len(t.a)
            assert repr(t) == 'Cnat32array()'
        print('ok'); sys.stdout.flush()

        print('Cnat32array.__getitem__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Cnat32array.__len__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Cnat32array.__repr__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Cnat32array.__setitem__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
