#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.bool Boolens : les 16 connecteurs binaires
#
# Cf. \htmlonly <a href="http://www.opimedia.be/logiques/" target="_blank">
#   <tt>http://www.opimedia.be/logiques/</tt></a>\endhtmlonly
#\htmlonly
#<table border="1" cellspacing="0" summary="connecteurs binaires">
#<tr align="center" style="color:gray">
#<td colspan="2" align="left">&ldquo;connecteur ngatif&rdquo;</td>
#<td style="background:gray"></td>
#<td class="math"><span style="margin-right:-.8ex">&nbsp;/</span>1</td>
#<td class="math"><span
#  style="margin-left:-.5ex;margin-right:-.5ex">&nbsp;&nbsp;/</span>|&nbsp;</td>
#<td class="math"><span style="margin-right:-1.2ex">&nbsp;/</span>&rarr;</td><td>&nbsp;</td>
#<td class="math"><span style="margin-right:-1.2ex">&nbsp;/</span>&larr;</td><td>&nbsp;</td>
#<td class="math"><span style="margin-right:-1.2ex">&nbsp;/</span>&harr;</td>
#<td class="math"><span style="margin-right:-.75ex">&nbsp;/</span>&darr;&nbsp;</td>
#<td style="background:gray"></td>
#<td class="math"><span style="margin-left:-.5ex;margin-right:-1ex">&nbsp;&nbsp;/</span>&or;</td>
#<td class="math"><span style="margin-right:-1.25ex">&nbsp;&nbsp;/</span>&oplus;</td>
#<td class="math"><span style="margin-right:-.75ex">&nbsp;/</span>b</td><td>&nbsp;</td>
#<td class="math"><span style="margin-right:-.75ex">&nbsp;/</span>a</td><td>&nbsp;</td>
#<td class="math"><span style="margin-right:-1.25ex">&nbsp;&nbsp;/</span>&and;</td>
#<td class="math"><span style="margin-right:-.8ex">&nbsp;/</span>0</td></tr>
#
#<tr style="background:gray"><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
#<td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
#<td></td><td></td><td></td></tr>
#<tr class="math" align="center"><th>a</th><th>b</th><th width="0" style="background:gray"></th>
#<th width="20">0</th><th width="20">&and;</th><th width="20">&nbsp;</th><th width="20">a</th>
#<th width="20">&nbsp;</th><th width="20">b</th><th width="20">&oplus;</th>
#<th width="20">&or;</th><th style="background:gray"></th><th width="20">&darr;</th>
#<th width="20">&harr;</th><th width="20">&nbsp;</th><th width="20">&larr;</th>
#<th width="20">&nbsp;</th><th width="20">&rarr;</th><th width="20">|</th><th width="20">1</th></tr>
#<tr style="background:gray"><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
#<td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
#<td></td><td></td><td></td></tr>
#
#<tr class="math" align="center"><th>0</th><th>0</th><td style="background:gray"></td><td>0</td>
#<td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td><td>0</td>
#<td style="background:gray"></td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td><td>1</td>
#<td>1</td><td>1</td></tr>
#<tr class="math" align="center"><th>0</th><th>1</th><td style="background:gray"></td><td>0</td>
#<td>0</td><td>0</td><td>0</td><td>1</td><td>1</td><td>1</td><td>1</td>
#<td style="background:gray"></td><td>0</td><td>0</td><td>0</td><td>0</td><td>1</td><td>1</td>
#<td>1</td><td>1</td></tr>
#<tr class="math" align="center"><th>1</th><th>0</th><td style="background:gray"></td><td>0</td>
#<td>0</td><td>1</td><td>1</td><td>0</td><td>0</td><td>1</td><td>1</td>
#<td style="background:gray"></td><td>0</td><td>0</td><td>1</td><td>1</td><td>0</td><td>0</td>
#<td>1</td><td>1</td></tr>
#<tr class="math" align="center"><th>1</th><th>1</th><td style="background:gray"></td><td>0</td>
#<td>1</td><td>0</td><td>1</td><td>0</td><td>1</td><td>0</td><td>1</td>
#<td style="background:gray"></td><td>0</td><td>1</td><td>0</td><td>1</td><td>0</td><td>1</td>
#<td>0</td><td>1</td></tr>
#<tr style="background:gray"><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
#<td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
#<td></td><td></td><td></td></tr>
#</table>
#\endhtmlonly

##\file
# Boolens : les 16 connecteurs binaires
#
# Cf. \htmlonly <a href="http://www.opimedia.be/logiques/" target="_blank">
#   <tt>http://www.opimedia.be/logiques/</tt></a>\endhtmlonly

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 3 juin 2007
####################################
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'bool --- 2010 April 12'



# ###########
# Fonctions #
#############
## Renvoie a (premier lment)
def bin_a(a, b):
    """Renvoie a
    (connecteur binaire : premier lment)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(a)


## Renvoie \htmlonly a &and; b\endhtmlonly (conjonction)
def bin_and(a, b):
    """Renvoie a et b
    (connecteur binaire : conjonction)
    !!! Contrairement  l'oprateur Python and, les deux arguments sont toujours valus

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(a) and bool(b)


## Renvoie b (second lment)
def bin_b(a, b):
    """Renvoie b
    (connecteur binaire : second lement)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(b)


## Renvoie \htmlonly a &harr; b\endhtmlonly (double implication, galit boolenne)
def bin_eq(a, b):
    """Renvoie a quivalent  b
    (connecteur binaire : double implication, galit boolenne)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(a) == bool(b)


## Renvoie False
def bin_false(a, b):
    """Renvoie False
    (connecteur binaire : constante faux)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: False

    O() = 1"""
    return False


## Renvoie \htmlonly a &rarr; b\endhtmlonly (implication)
def bin_imp(a, b):
    """Renvoie a implique b
    (connecteur binaire : implication)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(b) or not bool(a)


## Renvoie not a (ngation du premier lment)
def bin_na(a, b):
    """Renvoie not a
    (connecteur binaire : ngation du premier lment)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return not bool(a)


## Renvoie a | b (incompatibilit, barre de Sheffer, ngation du et)
def bin_nand(a, b):
    """Renvoie a est incompatible avec b
    (connecteur binaire : incompatibilit, barre de Sheffer, ngation du et)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return not(bool(a) and bool(b))


## Renvoie not b (ngation du second lment)
def bin_nb(a, b):
    """Renvoie not b
    (connecteur binaire : ngation du second lment)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return not bool(b)


## Renvoie \htmlonly not(a &rarr; b)\endhtmlonly (ngation de l'implication)
def bin_nimp(a, b):
    """Renvoie not(a implique b)
    (connecteur binaire : ngation de l'implication)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(a) and (not bool(b))


##\brief Renvoie \htmlonly a &darr; b\endhtmlonly
# (ngation conjointe, barre de Sheffer duale, ngation du ou)
def bin_nor(a, b):
    """Renvoie a ngation conjointe b
    (connecteur binaire : ngation conjointe, barre de Sheffer duale, ngation du ou)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return not(bool(a) or bool(b))


## Renvoie \htmlonly not(a &larr; b)\endhtmlonly (ngation de l'implication rciproque)
def bin_nrec(a, b):
    """Renvoie not(b implique a)
    (connecteur binaire : ngation de l'implication rciproque)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(b) and not bool(a)


## Renvoie \htmlonly a &or; b\endhtmlonly (disjonction inclusive)
def bin_or(a, b):
    """Renvoie a ou b
    (connecteur binaire : disjonction inclusive)
    !!! Contrairement  l'oprateur Python or, les deux arguments sont toujours valus

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(a) or bool(b)


## Renvoie \htmlonly a &larr; b\endhtmlonly (implication rciproque)
def bin_rec(a, b):
    """Renvoie b implique a
    (connecteur binaire : implication rciproque)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return bool(a) or not bool(b)


## Renvoie True
def bin_true(a, b):
    """Renvoie True
    (connecteur binaire : constante vraie)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: True

    O() = 1"""
    return True


## Renvoie \htmlonly a &oplus; b\endhtmlonly (disjonction exclusive)
def bin_xor(a, b):
    """Renvoie a xou b
    (connecteur binaire : disjonction exclusive)

    Pre: a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    a = bool(a)
    b = bool(b)
    return (a or b) and not (a and b)


## Renvoie a si t, b sinon (si alors sinon)
def ter_if(t, a, b):
    """Renvoie a si t, b sinon
    (connecteur ternaire : si alors sinon)

    Pre: t: valeur boolenne
         a: valeur boolenne
         b: valeur boolenne

    Result: bool

    O() = 1"""
    return (bool(a) if bool(t)
            else bool(b))



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        import sys

        import DSPython.debug as debug

        debug.test_begin(VERSION, __debug__)


        print('bin_a()...', end=''); sys.stdout.flush()
        assert bin_a(False, False) == False
        assert bin_a(False, True)  == False
        assert bin_a(True,  False) == True
        assert bin_a(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_and()...', end=''); sys.stdout.flush()
        assert bin_and(False, False) == False
        assert bin_and(False, True)  == False
        assert bin_and(True,  False) == False
        assert bin_and(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_b()...', end=''); sys.stdout.flush()
        assert bin_b(False, False) == False
        assert bin_b(False, True)  == True
        assert bin_b(True,  False) == False
        assert bin_b(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_eq()...', end=''); sys.stdout.flush()
        assert bin_eq(False, False) == True
        assert bin_eq(False, True)  == False
        assert bin_eq(True,  False) == False
        assert bin_eq(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_false()...', end=''); sys.stdout.flush()
        assert bin_false(False, False) == False
        assert bin_false(False, True)  == False
        assert bin_false(True,  False) == False
        assert bin_false(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_imp()...', end=''); sys.stdout.flush()
        assert bin_imp(False, False) == True
        assert bin_imp(False, True)  == True
        assert bin_imp(True,  False) == False
        assert bin_imp(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_na()...', end=''); sys.stdout.flush()
        assert bin_na(False, False) == True
        assert bin_na(False, True)  == True
        assert bin_na(True,  False) == False
        assert bin_na(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_nand()...', end=''); sys.stdout.flush()
        assert bin_nand(False, False) == True
        assert bin_nand(False, True)  == True
        assert bin_nand(True,  False) == True
        assert bin_nand(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_nb()...', end=''); sys.stdout.flush()
        assert bin_nb(False, False) == True
        assert bin_nb(False, True)  == False
        assert bin_nb(True,  False) == True
        assert bin_nb(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_nimp()...', end=''); sys.stdout.flush()
        assert bin_nimp(False, False) == False
        assert bin_nimp(False, True)  == False
        assert bin_nimp(True,  False) == True
        assert bin_nimp(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_nor()...', end=''); sys.stdout.flush()
        assert bin_nor(False, False) == True
        assert bin_nor(False, True)  == False
        assert bin_nor(True,  False) == False
        assert bin_nor(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_nrec()...', end=''); sys.stdout.flush()
        assert bin_nrec(False, False) == False
        assert bin_nrec(False, True)  == True
        assert bin_nrec(True,  False) == False
        assert bin_nrec(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print('bin_or()...', end=''); sys.stdout.flush()
        assert bin_or(False, False) == False
        assert bin_or(False, True)  == True
        assert bin_or(True,  False) == True
        assert bin_or(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_rec()...', end=''); sys.stdout.flush()
        assert bin_rec(False, False) == True
        assert bin_rec(False, True)  == False
        assert bin_rec(True,  False) == True
        assert bin_rec(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_true()...', end=''); sys.stdout.flush()
        assert bin_true(False, False) == True
        assert bin_true(False, True)  == True
        assert bin_true(True,  False) == True
        assert bin_true(True,  True)  == True
        print('ok'); sys.stdout.flush()


        print('bin_xor()...', end=''); sys.stdout.flush()
        assert bin_xor(False, False) == False
        assert bin_xor(False, True)  == True
        assert bin_xor(True,  False) == True
        assert bin_xor(True,  True)  == False
        print('ok'); sys.stdout.flush()


        print()
        print('ter_if()...', end=''); sys.stdout.flush()
        assert ter_if(False, False, False) == False
        assert ter_if(False, False, True)  == True
        assert ter_if(False, True,  False) == False
        assert ter_if(False, True,  True)  == True

        assert ter_if(True,  False, False) == False
        assert ter_if(True,  False, True)  == False
        assert ter_if(True,  True,  False) == True
        assert ter_if(True,  True,  True)  == True
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
