#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython.bintree Binary tree : arbre binaire gnrique
# !!! Work in progress !!!

##\file
# Binary tree : arbre binaire gnrique
# !!! Work in progress !!!

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 25 mars 2008
####################################
from __future__ import print_function

## Date du dernier changement pour ce module
VERSION = 'bintree --- 2010 March 16'



#???
# - copier (par copy.copy()) les morceaux d'arbre ?
# - EulerTour()
# - parcours prfixe, infixe, postfixe
# - depth, height, nbroot, nbsubleft, nbsubright



# ############
# Constantes #
##############
## Suites des parenthses gauches
PARENTSLEFT = ('(', '[', '{')

## Suites des parenthses droites
PARENTSRIGHT = (')', ']', '}')


## Suites des parenthses gauches pour (La)TeX en mode mathmatique
PARENTSLEFT_TEX = (r'\left(', r'\left[', r'\left{')

## Suites des parenthses droites pour (La)TeX en mode mathmatique
PARENTSRIGHT_TEX = (r'\right)', r'\right]', r'\right}')



# ########
# Classe #
##########
##\brief Arbre binaire gnrique
#
# Les 8 possibilits :\n
# \htmlonly <img src="bintree.png" alt="[bintree.png]">\endhtmlonly
class Bintree:
    """Arbre binaire gnrique"""

    ## Compare self et value
    def __cmp__(self, value):
        """Compare self et value

        Pre: les ventuelles racines de self et value doivent tre comparables par cmp()

        Result: -1, 0 ou 1

        O() = ..."""
        raise NotImplementedError#???


    ## Efface la racine
    def __delroot__(self):
        """Efface la racine (si elle existe)

        O() = 1"""
        if hasroot(self):
            del self._e


    ## Efface le sous-arbre binaire de gauche
    def __delsubleft__(self):
        """Efface le sous-arbre binaire de gauche (si il existe)

        O() = 1"""
        if hassubleft(self):
            del self._l


    ## Efface le sous-arbre binaire de droite
    def __delsubright__(self):
        """Efface le sous-arbre binaire de droite (si il existe)

        O() = 1"""
        if hassubright(self):
            del self._r


    ## Arbre binaire vide ?
    def __empty__(self):
        """Renvoie True si l'arbre binaire est vide
        (c.--d. si ni racine,
        ni sous-arbre de gauche, ni sous-arbre de droite),
        False sinon

        Result: bool

        O() = 1"""
        return not(hasroot(self) or hassubleft(self) or hassubright(self))


    ## self == value ?
    def __eq__(self, value):
        """Renvoie self == value

        Pre: les ventuelles racines de self et value doivent tre comparables par ==

        Result: bool

        O() = ..."""
        raise NotImplementedError#???
        return (isinstance(value, Bintree)
                and (not((hasroot(self) and hasroot(value)))
                     or (hasroot(self) and hasroot(value) and getroot(self) == getroot(value))))#...


    ## Renvoie la racine
    def __getroot__(self):
        """Renvoie la racine

        Pre: self: Bintree possdant une racine

        Result: objet

        O() = 1"""
        assert hasroot(self)

        return self._e


    ## Renvoie le sous-arbre binaire de gauche
    def __getsubleft__(self):
        """Renvoie le sous-arbre binaire de gauche

        Pre: self: Bintree possdant un sous-arbre binaire de gauche

        Result: Bintree

        O() = 1"""
        assert hassubleft(self)

        return self._l


    ## Renvoie le sous-arbre binaire de droite
    def __getsubright__(self):
        """Renvoie le sous-arbre binaire de droite

        Pre: self: Bintree possdant un sous-arbre binaire de droite

        Result: Bintree

        O() = 1"""
        assert hassubright(self)

        return self._r


    ## Arbre binaire avec une racine ?
    def __hasroot__(self):
        """Renvoie True si l'arbre binaire possde une racine,
        False sinon

        Result: bool

        O() = 1"""
        return hasattr(self, '_e')


    ## Arbre binaire avec un sous-arbre binaire de gauche ?
    def __hassubleft__(self):
        """Renvoie True si l'arbre binaire possde un sous-arbre binaire de gauche,
        False sinon

        Result: bool

        O() = 1"""
        return hasattr(self, '_l')


    ## Arbre binaire avec un sous-arbre binaire de droite ?
    def __hassubright__(self):
        """Renvoie True si l'arbre binaire possde un sous-arbre binaire de droite,
        False sinon

        Result: bool

        O() = 1"""
        return hasattr(self, '_r')


    ## Constucteur
    def __init__(self, *args):
        """Constucteur :
        Bintree() : arbre binaire vide
        Bintree(value) : arbre binaire avec value pour racine
        Bintree(value, left) : arbre binaire avec value pour racine
                               et left pour sous-arbre binaire de gauche
        Bintree(value, left, right) : arbre binaire avec value pour racine
                                      et left pour sous-arbre binaire de gauche
                                      et right pour sous-arbre binaire de droite

        Pre: args: vide
                   ou (Object)
                   ou (Object, Bintree)
                   ou (Object, Bintree, Bintree)

        O() = ..."""
        assert len(args) <= 3, (len(args), args)

        # self._e : lment de la racine
        # self._l : Bintree sous-arbre binaire de gauche
        # self._r : Bintree sous-arbre binaire de droite
        if len(args) > 0:
            self._e = args[0]
            if len(args) > 1:
                assert isinstance(args[1], Bintree), type(args[1])

                self._l = args[1]
                if len(args) > 2:
                    assert isinstance(args[2], Bintree), type(args[2])

                    self._r = args[2]


    ## Nombre de noeuds
    def __len__(self):
        """Renvoie le nombre de noeuds

        Result: naturel

        O() = ..."""
        return ((len(getsubleft(self)) if hassubleft(self)
                 else 0)
                + (len(getsubright(self)) if hassubright(self)
                   else 0)
                + (1 if hasroot(self)
                   else 0))


    ## self != value ?
    def __ne__(self, value):
        """Renvoie self != value

        Result: bool

        O() = ..."""
        return not(self == value)


    ## Renvoie l'arbre binaire sous forme de string ( partir d'un parcours prfixe)
    def __repr__(self):#???
        """Renvoie l'arbre binaire sous forme de string
        ( partir d'un parcours prfixe)
        (renvoie '(()())' si l'arbre binaire est vide)

        Result: string

        O() = ..."""
        return ''.join(('(',
                        repr(getroot(self) if hasroot(self)
                             else ''),
                        repr(getsubleft(self)) if hassubleft(self)
                             else '()',
                        repr(getsubright(self)) if hassubright(self)
                             else '()',
                        ')'))


    ## Vide l'arbre binaire
    def __setempty__(self):
        """Vide l'arbre binaire
        (c.--d. efface la racine,
        le sous-arbre de gauche et le sous-arbre de droite)

        O() = 1"""
        delroot(self)
        delsubleft(self)
        delsubright(self)


    ## Fixe la valeur de la racine  value
    def __setroot__(self, value):
        """Fixe la valeur de la racine  value

        O() = 1"""
        self._e = value


    ## Fixe le sous-arbre binaire de gauche  value
    def __setsubleft__(self, value):
        """Fixe le sous-arbre binaire de gauche  value

        Pre: value: Bintree

        O() = 1"""
        assert isinstance(value, Bintree), type(value)

        self._l = value


    ## Fixe le sous-arbre binaire de droite  value
    def __setsubright__(self, value):
        """Fixe le sous-arbre binaire de droite  value

        Pre: value: Bintree

        O() = 1"""
        assert isinstance(value, Bintree), type(value)

        self._r = value


    ## Renvoie l'arbre binaire sous forme de string ( partir d'un parcours prfixe)
    def __str__(self):#???
        """Renvoie l'arbre binaire sous forme de string
        ( partir d'un parcours prfixe)
        (renvoie '(()())' si l'arbre binaire est vide)

        Result: string

        O() = ..."""
        return ''.join(('(',
                        str(getroot(self) if hasroot(self)
                            else ''),
                        str(getsubleft(self)) if hassubleft(self)
                            else '()',
                        str(getsubright(self)) if hassubright(self)
                            else '()',
                        ')'))



# ######################
# Fonctions gnriques #
########################
## Excute t.__delroot__()
def delroot(t):
    """Excute t.__delroot__()"""
    t.__delroot__()


## Excute t.__delsubleft__()
def delsubleft(t):
    """Excute t.__delsubleft__()"""
    t.__delsubleft__()


## Excute t.__delsubright__()
def delsubright(t):
    """Excute t.__delsubright__()"""
    t.__delsubright__()


## Renvoie t.__empty__()
def empty(t):
    """Renvoie t.__empty__()"""
    return t.__empty__()


## Renvoie t.__getroot__()
def getroot(t):
    """Renvoie t.__getroot__()"""
    return t.__getroot__()


## Renvoie t.__getsubleft__()
def getsubleft(t):
    """Renvoie t.__getsubleft__()"""
    return t.__getsubleft__()


## Renvoie t.__getsubright__()
def getsubright(t):
    """Renvoie t.__getsubright__()"""
    return t.__getsubright__()


## Renvoie t.__hasroot__()
def hasroot(t):
    """Renvoie t.__hasroot__()"""
    return t.__hasroot__()


## Renvoie t.__hassubleft__()
def hassubleft(t):
    """Renvoie t.__hassubleft__()"""
    return t.__hassubleft__()


## Renvoie t.__hassubright__()
def hassubright(t):
    """Renvoie t.__hassubright__()"""
    return t.__hassubright__()


## Excute t.__setempty__()
def setempty(t):
    """Excute t.__setempty__()"""
    t.__setempty__()


## Excute t.__setroot__(value)
def setroot(t, value):
    """Excute t.__setroot__(value)"""
    t.__setroot__(value)


## Excute t.__setsubleft__(value)
def setsubleft(t, value):
    """Excute t.__setsubleft__(value)"""
    t.__setsubleft__(value)


## Excute t.__setsubright__(value)
def setsubright(t, value):
    """Excute t.__setsubright__(value)"""
    t.__setsubright__(value)



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du module"""
        import sys

        import DSPython.debug as debug

        debug.test_begin(VERSION, __debug__)

        print('PARENTSLEFT == {0}'.format(PARENTSLEFT)); sys.stdout.flush()
        assert isinstance(PARENTSLEFT, tuple)
        print('PARENTSRIGHT == {0}'.format(PARENTSRIGHT)); sys.stdout.flush()
        assert isinstance(PARENTSRIGHT, tuple)

        print('PARENTSLEFT_TEX == {0}'.format(PARENTSLEFT_TEX)); sys.stdout.flush()
        assert isinstance(PARENTSLEFT_TEX, tuple)
        print('PARENTSRIGHT_TEX == {0}'.format(PARENTSRIGHT_TEX)); sys.stdout.flush()
        assert isinstance(PARENTSRIGHT_TEX, tuple)



        print()
        print('Bintree()...', end=''); sys.stdout.flush()
        t = Bintree()
        t1 = Bintree('1')
        t2 = Bintree('2', t)
        t3 = Bintree('3', t1)
        t4 = Bintree('4', t2, t3)

        t3n = Bintree('/',
                      Bintree('+',
                              Bintree('*', Bintree('3'), Bintree('n')),
                              Bintree('1')),
                      Bintree('2'))
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__cmp__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__delroot__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__delsubleft__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__delsubright__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__empty__()...', end=''); sys.stdout.flush()
        assert t.__empty__(), t
        assert not t1.__empty__(), t1
        assert not t2.__empty__(), t2
        assert not t3.__empty__(), t3
        assert not t4.__empty__(), t4

        assert not t3n.__empty__(), t3n
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__eq__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__getroot__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__getsubleft__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__getsubright__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__hasroot__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__hassubleft__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__hassubright__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__len__()...', end=''); sys.stdout.flush()
        assert len(t)  == 0, (len(t),  t)
        assert len(t1) == 1, (len(t1), t1)
        assert len(t2) == 1, (len(t2), t2)
        assert len(t3) == 2, (len(t3), t3)
        assert len(t4) == 4, (len(t4), t4)

        assert len(t3n) == 7, (len(t3n), t3n)
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__ne__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__repr__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__setempty__()...', end=''); sys.stdout.flush()
        assert t.__empty__(), t
        t.__setempty__()
        assert t.__empty__(), t
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__setroot__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__setsubleft__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__setsubright__()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('Bintree.__str__()...', end=''); sys.stdout.flush()
        assert str(t) == '(()())', str(t)
        assert str(t1) == '(1()())', str(t1)
        assert str(t2) == '(2(()())())', str(t2)
        assert str(t3) == '(3(1()())())', str(t3)
        assert str(t4) == '(4(2(()())())(3(1()())()))', str(t4)

        assert str(t3n) == '(/(+(*(3()())(n()()))(1()()))(2()()))', str(t3n)
        print('???', end='')
        print('ok'); sys.stdout.flush()



        print()
        print('delroot()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('delsubleft()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('delsubright()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('empty()...', end=''); sys.stdout.flush()
        assert empty(t), t
        assert not empty(t1), t1
        assert not empty(t2), t2
        assert not empty(t3), t3
        assert not empty(t4), t4

        assert not empty(t3n), t3n
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('getroot()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('getsubleft()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('getsubright()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('hasroot()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('hassubleft()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('hassubright()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('setempty()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('setroot()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('setsubleft()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()


        print('setsubright()...', end=''); sys.stdout.flush()
        print('???', end='')
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
