#!/usr/bin/env python
# -*- coding: latin-1 -*-
##\package DSPython Paquetage DSPython : oprations arithmtiques et alentours

##\file
# Paquetage DSPython : oprations arithmtiques et alentours

# (c) Olivier Pirson --- DragonSoft
# http://www.opimedia.be/DS/
# Dbut le 29 dcembre 2006
####################################
from __future__ import print_function

## Date du dernier changement du paquetage DSPython
VERSION = 'DSPython --- 00.03.03 --- 2012 June 25'

import numbers

if __debug__:
    import sys

    assert sys.version_info[:2] >= (2, 6), \
           ('DSPython require Python 2.6 or better (*work on Python 3*)', sys.version)



## \mainpage DSPython
#
# <div align="center">
#   <b>Paquetage d&rsquo;oprations arithmtiques et alentours</b>\n
#   \htmlonly
#     <a class="net" href="http://www.opimedia.be/DS/" target="_blank"><img
#       src="DragonSoft_t.png" border="0" alt="DragonSoft" /></a>
#   \endhtmlonly
# </div>
#
# <div style="margin-top:1ex"><p>
#   Ncessite <a class="net" href="http://www.python.org/" target="_blank">Python</a>
#     2.6 ou plus rcent.
#   <b>Fonctionne avec Python 3</b>.
# </p><p>
#   <a class="relative" href="README.txt" target="_blank">README</a>
# </p><p>
#   Licence&nbsp;: &copy; Olivier <span style="font-variant:small-caps">Pirson</span>
#   &ndash;&nbsp;prochainement GPL ou LGPL ou ..?
# </p><p>
#   <a class="relative" href="references.htm" target="_blank">Rfrences</a>
# </p></div>
#
# <div align="right">
#   &copy; Olivier <span style="font-variant:small-caps">Pirson</span>\n
#   <a class="mail"
#     href="mailto:dragonsoft_ds@yahoo.fr?subject=[DSPython]"><tt>dragonsoft_ds@yahoo.fr</tt></a>\n
#   <a class="net"
#     href="http://www.opimedia.be/DS/" target="_blank"><tt>http://www.opimedia.be/DS/</tt></a>
# </div>
#
# <hr>
# <div align="center">
#   Document gnr par\n
#   \htmlonly
#     <a class="net" href="http://www.doxygen.org/"
#       target="_blank"><img src="doxygen.png" border="0" alt="Doxygen" /></a>
#   \endhtmlonly
# </div>
#



# ############
# Constantes #
##############
## Adresse email de DragonSoft dans un string
DS_mail = 'dragonsoft_ds@yahoo.fr'

## Adresse du site web DragonSoft dans un string
DS_web = 'http://www.opimedia.be/DS/'



# ###########
# Fonctions #
#############
## n est un entier naturel (Integral >= 0) tenant sur 32 bits (< 2**32) ?
def nat32_is(n):
    """Renvoie True si n est un entier naturel (Integral >= 0) tenant sur 32 bits (< 2**32),
    False sinon

    Result: bool

    O(n) = 1"""
    return isinstance(n, numbers.Integral) and (4294967295 >= n >= 0)


## n est un entier naturel (Integral >= 0) ?
def natural_is(n):
    """Renvoie True si n est un entier naturel (Integral >= 0),
    False sinon

    Result: bool

    O(n) = 1"""
    return isinstance(n, numbers.Integral) and (n >= 0)



# ######\cond MAINTEST
# Main #
########
if __name__ == '__main__':
    def main_test():
        """Test du paquetage"""
        import sys

        import DSPython.debug as debug

        debug.test_begin(VERSION, __debug__, header='Package ')

        print('DS_mail ==', repr(DS_mail)); sys.stdout.flush()
        print('DS_web ==', repr(DS_web)); sys.stdout.flush()


        print()
        print('nat32_is()...', end=''); sys.stdout.flush()
        assert nat32_is(0)
        assert nat32_is(1)
        assert nat32_is(2)
        for k in range(32):
            assert natural_is(2**k - 1), 2**k - 1
            assert natural_is(2**k),     2**k
            assert natural_is(2**k + 1), 2**k + 1
        assert natural_is(2**32 - 1), 2**32 - 1
        assert natural_is(int(55))
        assert nat32_is(False)
        assert nat32_is(True)

        assert not nat32_is(-1)
        assert not nat32_is(2**32)
        assert not nat32_is(0.0)
        assert not nat32_is(.1)
        assert not nat32_is(complex(0, 0))
        assert not nat32_is(None)
        print('ok'); sys.stdout.flush()


        print('natural_is()...', end=''); sys.stdout.flush()
        assert natural_is(0)
        assert natural_is(1)
        assert natural_is(2)
        for k in range(100):
            assert natural_is(2**k - 1), 2**k - 1
            assert natural_is(2**k),     2**k
            assert natural_is(2**k + 1), 2**k + 1
        assert natural_is(int(55))
        assert natural_is(False)
        assert natural_is(True)

        assert not natural_is(-1)
        assert not natural_is(0.0)
        assert not natural_is(.1)
        assert not natural_is(complex(0, 0))
        assert not natural_is(None)
        print('ok'); sys.stdout.flush()
        debug.test_end()

    main_test()
##\endcond MAINTEST
